package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectConclusionPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectConclusionQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectConclusionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsInspectionItemConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectConclusionVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目结项
 *
 * @author xxb
 * @date 2023-11-27
 */
@Api(tags = "项目结项")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsProjectConclusion")
@Slf4j
public class PmsProjectConclusionController {

    private final PmsProjectConclusionService pmsProjectConclusionService;

    /**
     * 项目结项-新增/更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目结项-新增/更新")
    @GlobalTransactional
    public TwOutputUtil<PmsProjectConclusionVO> insertOrUpdate(@RequestBody PmsProjectConclusionPayload payload) {
        pmsProjectConclusionService.insertOrUpdate(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 根据项目id查询项目结项
     *
     * @param projectId
     * @return
     */
    @GetMapping("/queryByProjectId")
    @UdcNameClass
    @ApiOperation("根据项目id查询项目结项")
    public TwOutputUtil<PmsProjectConclusionVO> queryByProjectId(@RequestParam Long projectId) {
        return TwOutputUtil.ok(pmsProjectConclusionService.queryByProjectId(projectId));
    }

    /**
     * 项目结项-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/queryByKey")
    @UdcNameClass
    @ApiOperation("项目结项-主键查询")
    public TwOutputUtil<PmsProjectConclusionVO> queryByKey(Long key, String approvalNode) {
        return TwOutputUtil.ok(pmsProjectConclusionService.queryByKey(key, approvalNode));
    }

    /**
     * 项目结项-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/pagingJoinProject")
    @UdcNameClass
    @ApiOperation("项目结项-分页")
    public TwOutputUtil<PagingVO<PmsProjectConclusionVO>> pagingJoinProject(PmsProjectConclusionQuery query) {
        return TwOutputUtil.ok(pmsProjectConclusionService.queryPagingJoinProject(query));
    }

    /**
     * 项目结项-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("项目结项-查询列表")
    public TwOutputUtil<List<PmsProjectConclusionVO>> queryList(PmsProjectConclusionQuery query) {
        return TwOutputUtil.ok(pmsProjectConclusionService.queryListDynamic(query));
    }

    /**
     * 项目结项-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目结项-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsProjectConclusionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 项目结项-自动检查
     *
     * @param projectId
     * @param workType
     * @param approvalNode
     * @return
     */
    @GetMapping("/autoCheck")
    @UdcNameClass
    @ApiOperation("项目结项-自动检查")
    public TwOutputUtil<List<PmsInspectionItemConfigVO>> autoCheck(Long projectId, String workType, String approvalNode) {
        return TwOutputUtil.ok(pmsProjectConclusionService.autoCheck(projectId, workType, approvalNode));
    }


}
