package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectMembersPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectMembersQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectMembersService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectMembersVO;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectMembersConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectMembersDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectMembersDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectMembersRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目成员
 *
 * @author xxb
 * @date 2023-08-10
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectMembersServiceImpl extends BaseServiceImpl implements PmsProjectMembersService {

    private final PmsProjectMembersRepo pmsProjectMembersRepo;
    private final PmsProjectMembersDAO pmsProjectMembersDAO;

    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final TaskCommonService taskCommonService;
    private final CacheUtil cacheUtil;

    @Override
    public Long countTreeByProjId(PmsProjectMembersQuery query){
        return pmsProjectMembersDAO.count(query);
    }

    @Override
    public List<PmsProjectMembersVO> queryTreeByProjId(PmsProjectMembersQuery query) {
        List<PmsProjectMembersVO> membersVOS = pmsProjectMembersDAO.queryListDynamic(query);
        if (membersVOS.size() > 0) {
            //获取任务包数量，为了功能解耦暂不关联查
            List<Long> resIds = membersVOS.stream().map(PmsProjectMembersVO::getResId).distinct().collect(Collectors.toList());
            TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
            taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
            taskPackageQuery.setReasonId(query.getProjId());
            taskPackageQuery.setReceiverResIds(resIds);
            List<TaskPackageVO> taskPackageVOS = taskCommonService.queryTaskPackageList(taskPackageQuery);
            Map<Long, List<TaskPackageVO>> mapList = taskPackageVOS.stream().collect(Collectors.groupingBy(TaskPackageVO::getReceiverResId));
            membersVOS.forEach(membersVO -> {
                membersVO.setTaskPackageCount(0);
                List<TaskPackageVO> taskPackageVOS1 = mapList.get(membersVO.getResId());
                if (!ObjectUtils.isEmpty(taskPackageVOS1)) {
                    membersVO.setTaskPackageCount(taskPackageVOS1.size());
                }
            });
            setCapaInfo(membersVOS);
        }

        return membersVOS;
    }

    @Override
    public PagingVO<PmsProjectMembersVO> queryPaging(PmsProjectMembersQuery query) {
        return pmsProjectMembersDAO.queryPaging(query);
    }

    @Override
    public List<PmsProjectMembersVO> queryListDynamic(PmsProjectMembersQuery query) {
        if (ObjectUtils.isEmpty(query.getProjId())) {
            throw TwException.error("", "项目id 不能为空 ");
        }
        List<PmsProjectMembersVO> membersVOS = pmsProjectMembersDAO.queryListDynamic(query);
        // 设置 复合能力
        setCapaInfo(membersVOS);
        return membersVOS;
    }

    @Override
    public PmsProjectMembersVO queryByKey(Long key) {
        PmsProjectMembersDO entity = pmsProjectMembersRepo.findById(key).orElseGet(PmsProjectMembersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsProjectMembersVO vo = PmsProjectMembersConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectMembersVO insertOrUpdate(PmsProjectMembersPayload payload) {
        // 验空
        checkData(payload);
        if (ObjectUtils.isEmpty(payload.getWorkbenchFlag())) {
            payload.setWorkbenchFlag(1);
        }
        // 一个项目下，资源id需唯一
        if (!ObjectUtils.isEmpty(payload.getResId())) {
            PmsProjectMembersVO vo = pmsProjectMembersDAO.queryByProjAndRes(payload.getProjId(), payload.getResId());
            if (!ObjectUtils.isEmpty(vo)) {
                if (!vo.getId().equals(payload.getId())) {
                    throw TwException.error("", "项目成员已经存在！");
                }
            }
        }
        return PmsProjectMembersConvert.INSTANCE.toVo(pmsProjectMembersDAO.save(PmsProjectMembersConvert.INSTANCE.toDo(payload)));
    }

    @Override
    public PmsProjectMembersVO insertFromTask(Long projId, Long resId) {
        PmsProjectMembersVO pmsProjectMembersVO = pmsProjectMembersDAO.queryByProjAndRes(projId, resId);
        if (ObjectUtils.isEmpty(pmsProjectMembersVO)) {
            PmsProjectMembersPayload membersPayload = new PmsProjectMembersPayload();
            membersPayload.setProjId(projId);
            membersPayload.setResId(resId);
            membersPayload.setWorkbenchFlag(1);
            return PmsProjectMembersConvert.INSTANCE.toVo(pmsProjectMembersDAO.save(PmsProjectMembersConvert.INSTANCE.toDo(membersPayload)));
        }
        return null;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsProjectMembersPayload payload) {
        PmsProjectMembersDO entity = pmsProjectMembersRepo.findById(payload.getId()).orElseGet(PmsProjectMembersDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = pmsProjectMembersDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectMembersVO> pmsProjectMembersVOS = pmsProjectMembersDAO.queryByKeys(keys);
            if (pmsProjectMembersVOS.size() > 0) {
                List<Long> collect = pmsProjectMembersVOS.stream().map(PmsProjectMembersVO::getProjId).distinct().collect(Collectors.toList());
                if (collect.size() > 1) {
                    throw TwException.error("", "不可同时删除多项目下的成员");
                }
                List<Long> resIds = pmsProjectMembersVOS.stream().map(PmsProjectMembersVO::getResId).distinct().collect(Collectors.toList());

                TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
                taskPackageQuery.setReasonType(PmsReasonTypeEnum.PROJ_CONTRACT.getCode());
                taskPackageQuery.setReasonId(collect.get(0));
                taskPackageQuery.setReceiverResIds(resIds);
                long l = taskCommonService.taskPackageCount(taskPackageQuery);
                if (l > 0) {
                    throw TwException.error("", "已生成任务包，不可删除成员");
                }
                pmsProjectMembersDAO.deleteSoft(keys);
            }
        }
    }


    /**
     * 验证数据
     *
     * @param payload
     */
    private void checkData(PmsProjectMembersPayload payload) {
        if (ObjectUtils.isEmpty(payload.getProjId())) {
            throw TwException.error("", "项目Id不能为空");
        }
        if (ObjectUtils.isEmpty(payload.getRole())) {
            throw TwException.error("", "角色不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getCapasetLevelId())) {
            throw TwException.error("", "复合能力ID不能为空，请核验！");
        }
        if (!ObjectUtils.isEmpty(payload.getPlanStartDate()) && !ObjectUtils.isEmpty(payload.getPlanEndDate())) {
            if (payload.getPlanStartDate().isAfter(payload.getPlanEndDate())) {
                throw TwException.error("", "预计结束日期不应该早于预计开始日，请核验！");
            }
        }
    }

    /**
     * 设置复合能力相关 信息
     *
     * @param membersVOS
     */
    private void setCapaInfo(List<PmsProjectMembersVO> membersVOS) {
        if (!ObjectUtils.isEmpty(membersVOS)) {
            // 设置 复合能力
            List<Long> capasetLevelIds = membersVOS.stream().filter(v -> !ObjectUtils.isEmpty(v.getCapasetLevelId())).map(v -> v.getCapasetLevelId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(capasetLevelIds)) {
                PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
                prdCompositeAbilityQuery.setIds(capasetLevelIds);
                List<PrdCompositeAbilityVO> levelVOS = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
                Map<Long, PrdCompositeAbilityVO> info = levelVOS.stream().collect(Collectors.toMap(PrdCompositeAbilityVO::getId, Function.identity()));
                membersVOS.forEach(v -> {
                    Long capasetLevelId = v.getCapasetLevelId();
                    if (!ObjectUtils.isEmpty(capasetLevelId)) {
                        PrdCompositeAbilityVO levelVO = info.get(capasetLevelId);
                        if (!ObjectUtils.isEmpty(levelVO)) {
                            v.setEqvaRatio(levelVO.getDlRatio());
                            v.setCapasetLevelDesc(levelVO.getName());
                        }
                    }
                });
            }
        }
    }

}
