package com.elitesland.tw.tw5.server.prd.purchase.purenum;

import com.elitesland.tw.tw5.server.common.TwException;
import lombok.Getter;

/**
 * @author likunpeng
 * @date 2023/12/22
 * 采购合同枚举类
 */
public interface PurchaseContractEnum {

    /**
     * 采购合同类型
     */
    @Getter
    enum PurchaseConType implements PurchaseContractEnum {
        RESOURCE("resources", "资源赋能类采购"),
        COMPANY("company", "公司管理类采购"),
        OPERATE("operate", "行政运营类采购"),
        RESEARCH("research", "研发类采购"),
        MARKET("market", "市场渠道"),
        PROJECT_PURCHASE("project_purchase", "项目采购"),
        CON_PURCHASE("con_purchase", "合同采购"),
        ;

        private final String code;
        private final String desc;

        PurchaseConType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PurchaseConType match(String code) {
            for (PurchaseConType purchaseConType : PurchaseConType.values()) {
                if (purchaseConType.getCode().equals(code)) {
                    return purchaseConType;
                }
            }
            throw TwException.error("", "未找到相关的采购合同类型，请检查");
        }
    }

    /**
     * 业务性质类型
     */
    @Getter
    enum PurchaseBusinessType implements PurchaseContractEnum {
        HOUSE_RENTAL("house_rental", "房屋租赁"),
        EMPTY("empty", "空"),
        IND_RESOURCE("ind_resource", "个体资源外包"),
        PUBLIC_OUTSOURCING_SUBMIT("public_outsourcing_submit", "对公资源外包（提点）"),
        PUBLIC_OUTSOURCING("public_outsourcing", "对公资源外包"),
        PRE_SALE("pre_sale", "个体售前资源外包"),
        BID_SECURITY("bid_security", "投标保证金"),
        MIS_PURCHASE("mis_purchase", "杂项采购"),
        OUTSOURCING("outsourcing", "外包"),
        TRADE_PRODUCT("trade_product", "产品贸易"),
        TRADE_SERVICES("trade_services", "服务贸易"),
        ;

        private final String code;
        private final String desc;

        PurchaseBusinessType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PurchaseBusinessType match(String purBusinessTypeCode) {
            for (PurchaseBusinessType purchaseBusinessType : PurchaseBusinessType.values()) {
                if (purchaseBusinessType.getCode().equals(purBusinessTypeCode)) {
                    return purchaseBusinessType;
                }
            }
            throw TwException.error("", "未找到相关的业务性质类型，请检查");
        }
    }
}
