package com.elitesland.tw.tw5.server.prd.purchase.workflow;

import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentPlanService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchasePaymentDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentPlanRepo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;

@Slf4j
@RestController
@RequestMapping(path = {
        WorkflowConstant.WORKFLOW + "PUR_TRADE_SERVICE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_TRADE_PRODUCT" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_OUTSOURCING" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_BID_SECURITY" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_HOUSE_RENTAL" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_MIS_PURCHASE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_PUBLIC_OUTSOURCE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_MARKET" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_RESEARCH" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_OPERATE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_COMPANY" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_RESOURCE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_AGREEMENT" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_SALARY_PAYMENT" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_ADVANCE_PAY_W_O" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_ADVANCE_PAY_ONE" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_ADVANCE_PAY_TWO" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_ADVANCE_PAY_T" + WorkflowConstant.CALLBACK,
        WorkflowConstant.WORKFLOW + "PUR_ADVANCE_PAY_FOUR" + WorkflowConstant.CALLBACK,
})
@Transactional
@RequiredArgsConstructor
public class PaymentApplyWorkFlowCallBackController implements WorkflowCallBack {

    private final PurchasePaymentService service;
    private final PaymentSlipService paymentSlipService;
    private final PurchasePaymentPlanRepo purchasePaymentPlanRepo;
    private final PurchasePaymentDAO purchasePaymentDAO;
    private final ResWithdrawApplyService resWithdrawApplyService;
    private final PurchasePaymentPlanService purchasePaymentPlanService;
    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        Long businessKey;
        try {
            businessKey = Long.valueOf(payload.getBusinessKey());
        }catch (Exception e) {
            throw TwException.error("", "业务key格式有误，请检查");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PurchasePaymentPayload purchasePaymentPayload = new PurchasePaymentPayload();
        purchasePaymentPayload.setId(businessKey);
        //根据业务key查询当前业务对象
        PurchasePaymentVO purchasePaymentVO = service.queryByKey(businessKey);
        if (purchasePaymentVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT -> {//创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    purchasePaymentPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                }
                case INTERRUPT -> {//中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                    purchasePaymentPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                }
                case INVALID -> {
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.CREATE.getCode());
                    // 调用删除接口
                    service.deleteSoft(businessKey, true);
                    log.info("付款申请单流程作废，业务id为{}", businessKey);
                    return WorkflowResult.success(null);
                }
                case REJECTED -> {
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVING.getCode());
                    purchasePaymentPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    // 判断是否需要驳回后再提交
                    Set<String> taskDefKeys = new HashSet<>(
                            Arrays.asList("Activity_0mf1yt5", "Activity_0dhpjob", "Activity_0yg7k51", "Activity_1iix5xs", "Activity_1vsr5vw",
                                    "Activity_0djs312", "Activity_1v6lkgq", "Activity_0dtkif5", "Activity_0cz6syb", "Activity_1v4n1lp",
                                    "Activity_0bqqora", "Activity_0r0ys3x", "Activity_0u3fzyw", "Activity_0wyypz8", "Activity_1293qp1",
                                    "Activity_0my8y42", "Activity_1q8av5u")
                    );
                    if (taskDefKeys.contains(payload.getCommentInfo().getTaskDefKey())) {
                        log.info("应付会计驳回后再提交");
                        purchasePaymentPayload.setIsResubmit(true);
                    }
                }
                case APPROVED -> {
                    purchasePaymentPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchasePaymentPayload.setApprovedTime(LocalDateTime.now());
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVED.getCode());
                    // 将付款申请单状态修改为“待应付会计提交”
                    paymentSlipService.updateStatusByPaymentApplyId(businessKey, PurchasePaymentEnum.PaymentSlipStatus.READY.getCode());
                    // 付款申请单类型
                    String paymentApplicationType = purchasePaymentVO.getPaymentApplicationType();

                    switch (PurchasePaymentEnum.PaymentType.match(paymentApplicationType)) {
                        // 采购合同 拆分付款计划（未完成付款的付款计划需要进行拆分）
                        case CONTRACT -> this.paymentPlanSplit(purchasePaymentVO.getPurchasePaymentPlanVOS());
                        // 预付款时，如果关联单据为采购合同，也进行拆分
                        case ADVANCE_PAY ->{
                            if (PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())) {
                                this.paymentPlanSplit(purchasePaymentVO.getPurchasePaymentPlanVOS());
                            }
                        }
                        // 预付款核销 根据金额修改前置预付款申请单状态
                        case ADVANCE_PAY_WRITE_OFF -> {
                            String prePaymentNo = purchasePaymentVO.getPrePaymentNo();
                            if (prePaymentNo != null) {
                                // 本次核销金额
                                BigDecimal currPaymentAmt = Optional.ofNullable(purchasePaymentVO.getCurrPaymentAmt()).orElse(BigDecimal.ZERO);
                                // 查询预付款申请单付款金额
                                BigDecimal currPaymentAmtByNo = purchasePaymentDAO.findCurrPaymentAmtByNo(prePaymentNo);
                                // 查询预付款申请单已核销金额
                                BigDecimal writeOffAmtByPrePaymentNo = purchasePaymentPlanService.findWriteOffAmtByPrePaymentNo(prePaymentNo);
                                writeOffAmtByPrePaymentNo = writeOffAmtByPrePaymentNo == null ? BigDecimal.ZERO : writeOffAmtByPrePaymentNo;
                                // 如果本次核销金额 + 已核销金额 >= 应核销金额金额 状态：已核销
                                if (currPaymentAmt.add(writeOffAmtByPrePaymentNo).compareTo(currPaymentAmtByNo) >= 0) {
                                    purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITTEN_OFF);
                                    // 查询合同是否满足关闭条件，如果满足将合同关闭 如果是合同才需要去关闭 协议不需要关闭
                                    if(PurchasePaymentEnum.PaymentDocType.CONTRACT.getCode().equals(purchasePaymentVO.getDocType())){
                                        paymentSlipService.closePaymentContract(purchasePaymentVO.getDocNo());
                                    }
                                    // 如果 0 < 核销金额 < 应付金额 状态：部分核销
                                } else if (currPaymentAmt.add(writeOffAmtByPrePaymentNo).compareTo(BigDecimal.ZERO) > 0) {
                                    purchasePaymentDAO.updatePaymentStatus(prePaymentNo, PurchasePaymentEnum.PaymentStatus.WRITE_OFF_PART);
                                    // 如果核销金额 < 0 抛出异常：预付款核销金额有误
                                } else {
                                    throw TwException.error("", "预付款核销金额有误");
                                }
                            }
                        }
                        // 按照采购协议付款，更改提现申请单的状态为付款已审批
                        case AGREEMENT -> resWithdrawApplyService.updateWithdrawStatusByPaymentApplyId(businessKey, PurchasePaymentEnum.WithdrawStatus.APPROVED.getCode());
                    }
                }
                case APPROVING -> {
                    purchasePaymentPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchasePaymentPayload.setState(PurchasePaymentEnum.PaymentStatus.APPROVING.getCode());
                }
            }
            log.info("流程执行，付款申请单修改结果: {}", purchasePaymentPayload);
            service.updateByKeyDynamic(purchasePaymentPayload);
        }
        return WorkflowResult.success(null);
    }


    /**
     * 付款计划拆分逻辑
     * @param purchasePaymentPlanVOS 需要进行拆分的付款计划
     */
    private void paymentPlanSplit(List<PurchasePaymentPlanVO> purchasePaymentPlanVOS) {
        purchasePaymentPlanVOS.forEach(purchasePaymentPlanVO -> {
            // 应付金额
            BigDecimal paymentAmt = purchasePaymentPlanVO.getPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getPaymentAmt();
            // 本次付款金额
            BigDecimal currentPaymentAmt = purchasePaymentPlanVO.getCurrentPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanVO.getCurrentPaymentAmt();
            // 新增付款计划列表
            List<PurchasePaymentPlanDO> purchasePaymentPlanDOS = new ArrayList<>();
            // 如果本次付款金额小于应付金额，拆出一条付款计划
            if (currentPaymentAmt.compareTo(paymentAmt) < 0) {
                PurchasePaymentPlanDO purchasePaymentPlanDO = new PurchasePaymentPlanDO();
                // 付款阶段
                purchasePaymentPlanDO.setPaymentStage(purchasePaymentPlanVO.getPaymentStage());
                // 应付款金额
                purchasePaymentPlanDO.setPaymentAmt(paymentAmt.subtract(currentPaymentAmt));
                // 本次付款金额
                purchasePaymentPlanDO.setCurrentPaymentAmt(BigDecimal.ZERO);
                // 预计付款日期
                purchasePaymentPlanDO.setEstimatedPaymentDate(purchasePaymentPlanVO.getEstimatedPaymentDate());
                // 单据Id
                purchasePaymentPlanDO.setContractId(purchasePaymentPlanVO.getContractId());
                // 单据编号
                purchasePaymentPlanDO.setContractNo(purchasePaymentPlanVO.getContractNo());
                // 设置付款状态为未付款
                purchasePaymentPlanDO.setPaymentStatus(PurchasePaymentEnum.PaymentPlanPayStatus.UNPAID.getCode());
                // 约束里程碑
                purchasePaymentPlanDO.setMilestone(purchasePaymentPlanVO.getMilestone());
                // 单据类型
                purchasePaymentPlanDO.setDocType(purchasePaymentPlanVO.getDocType());
                // 约束合同节点
                purchasePaymentPlanDO.setContractNode(purchasePaymentPlanVO.getContractNode());
                purchasePaymentPlanDOS.add(purchasePaymentPlanDO);
            }
            // 保存拆分后的付款计划
            if (purchasePaymentPlanDOS.size() > 0) {
                purchasePaymentPlanRepo.saveAll(purchasePaymentPlanDOS);
            }
        });
    }
}

