package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionRulePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionRuleQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissonRuleService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

/**
 * 权限规则
 *
 * @Author Bill
 * @Date 2023/9/25 15:51
 **/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemPermissonRuleController {

    private final PrdSystemPermissonRuleService service;

    /**
     * 绑定数据规则
     * @param payload
     * @return
     */
    @PostMapping("/dataRule/insert")
    public TwOutputUtil insert(@RequestBody PrdSystemPermissionRulePayload payload) {
        service.insert(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 权限规则模糊分页
     * @param query
     * @return
     */
    @GetMapping("/dataRule/paging")
    public TwOutputUtil paging(PrdSystemPermissionRuleQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 绑定数据删除
     * @param keys
     * @return
     */
    @DeleteMapping("/dataRule/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.delete(keys);
        return TwOutputUtil.ok();
    }

    /**
     * 绑定数据修改
     * @param payload
     * @return
     */
    @PutMapping("/dataRule/update")
    public TwOutputUtil update(@RequestBody PrdSystemPermissionRulePayload payload){
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 主键查询
     * @param key
     * @return
     */
    @GetMapping("/dataRule/{key}")
    public TwOutputUtil get(@PathVariable Long key) {
        return TwOutputUtil.ok(service.get(key));
    }

    /**
     * 根据用户查询数据权限
     *
     * @param query
     * @return
     */
    @GetMapping("/dataRule/pagingByUser")
    public TwOutputUtil pagingByUser(PrdSystemPermissionRuleQuery query) {
        return TwOutputUtil.ok(service.pagingByUser(query));
    }

    /**
     * 查询权限字段
     *
     * @param query
     * @return
     */
    @GetMapping("/dataRule/listField")
    public TwOutputUtil listField(PrdSystemPermissionFieldQuery query) {
        return TwOutputUtil.ok(service.listField(query));
    }

}
