package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemSelectionPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemSelectionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemSelectionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemSelectionDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemSelectionRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 系统选择项dao
 *
 * @author wangding
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemSelectionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemSelectionRepo repo;
    private final QPrdSystemSelectionDO qdo = QPrdSystemSelectionDO.prdSystemSelectionDO;
    private final QPrdSystemFunctionDO qdoFunction = QPrdSystemFunctionDO.prdSystemFunctionDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemSelectionDO save(PrdSystemSelectionDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemSelectionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemSelectionVO.class,
                qdo.id,
                qdo.selectionKey,
                qdo.selectionName,
                qdo.selectionNameLocale,
                qdo.selectionValue,
                qdo.parentId,
                qdo.functionId,
                qdoFunction.functionName,
                qdo.sortNo,
                qdo.remark,
                qdo.allowChange,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.extString10,
                qdo.createUserId,
                qdo.createTime,
                qdo.disabled
        )).from(qdo).leftJoin(qdoFunction).on(qdo.functionId.eq(qdoFunction.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemSelectionVO> getJpaQueryWhere(PrdSystemSelectionQuery query) {
        JPAQuery<PrdSystemSelectionVO> jpaQuery = getJpaQuerySelect();
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            jpaQuery.where(qdo.functionId.eq(query.getFunctionId()));
        }


        if (!ObjectUtils.isEmpty(query.getSelectionKey())) {
            jpaQuery.where(qdo.selectionKey.eq(query.getSelectionKey()));
        }
        if (!ObjectUtils.isEmpty(query.getSelectionName())) {
            jpaQuery.where(qdo.selectionName.like(SqlUtil.toSqlLikeString(query.getSelectionName())));
        }
        if (!ObjectUtils.isEmpty(query.getSelectionNameLocale())) {
            jpaQuery.where(qdo.selectionNameLocale.eq(query.getSelectionNameLocale()));
        }
        if (!ObjectUtils.isEmpty(query.getSelectionValue())) {
            jpaQuery.where(qdo.selectionValue.eq(query.getSelectionValue()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdo.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            jpaQuery.where(qdo.sortNo.eq(query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.like(SqlUtil.toSqlLikeString(query.getRemark())));
        }
        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qdo.id.ne(query.getId()));
        }
        if (!ObjectUtils.isEmpty(query.getAllowChange())) {
            jpaQuery.where(qdo.allowChange.eq(query.getAllowChange()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString1())) {
            jpaQuery.where(qdo.extString1.eq(query.getExtString1()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString2())) {
            jpaQuery.where(qdo.extString2.eq(query.getExtString2()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString3())) {
            jpaQuery.where(qdo.extString3.eq(query.getExtString3()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString4())) {
            jpaQuery.where(qdo.extString4.eq(query.getExtString4()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString5())) {
            jpaQuery.where(qdo.extString5.eq(query.getExtString5()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString6())) {
            jpaQuery.where(qdo.extString6.eq(query.getExtString6()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString7())) {
            jpaQuery.where(qdo.extString7.eq(query.getExtString7()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString8())) {
            jpaQuery.where(qdo.extString8.eq(query.getExtString8()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString9())) {
            jpaQuery.where(qdo.extString9.eq(query.getExtString9()));
        }
        if (!ObjectUtils.isEmpty(query.getExtString10())) {
            jpaQuery.where(qdo.extString10.eq(query.getExtString10()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemSelectionVO> getJpaQuerySelectList() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemSelectionVO.class,
                qdo.id,
                qdo.selectionKey,
                qdo.selectionName,
                qdo.selectionNameLocale,
                qdo.selectionValue,
                qdo.parentId,
                qdo.functionId,
                qdo.sortNo,
                qdo.extString10,
                qdo.extString1,
                qdo.extString2,
                qdo.extString3,
                qdo.extString4,
                qdo.extString5,
                qdo.extString6,
                qdo.extString7,
                qdo.extString8,
                qdo.extString9,
                qdo.disabled,
                qdo.remark
        )).from(qdo);
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemSelectionVO> queryListDynamic(PrdSystemSelectionQuery query) {
        JPAQuery<PrdSystemSelectionVO> jpaQuery = getJpaQuerySelectList();
        if (!ObjectUtils.isEmpty(query.getSelectionKey())) {
            jpaQuery.where(qdo.selectionKey.eq(query.getSelectionKey()));
        }
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            jpaQuery.where(qdo.functionId.eq(query.getFunctionId()));
        }
        if (!ObjectUtils.isEmpty(query.getId())) {
            jpaQuery.where(qdo.id.ne(query.getId()));
        }
//        jpaQuery.where(qdo.tenantId.eq(1L));
        List<OrderItem> orderse = new ArrayList<>();
        orderse.add(OrderItem.asc("sortNo"));
        orderse.add(OrderItem.desc("createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, orderse));
        return jpaQuery.fetch();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PrdSystemSelectionPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));

        if (payload.getSelectionKey() != null) {
            update.set(qdo.selectionKey, payload.getSelectionKey());
        }
        if (payload.getSelectionName() != null) {
            update.set(qdo.selectionName, payload.getSelectionName());
        }
        if (payload.getSelectionNameLocale() != null) {
            update.set(qdo.selectionNameLocale, payload.getSelectionNameLocale());
        }
        if (payload.getFunctionId() != null) {
            update.set(qdo.functionId, payload.getFunctionId());
        }

        if (payload.getSelectionValue() != null) {
            update.set(qdo.selectionValue, payload.getSelectionValue());
        }
        if (payload.getParentId() != null && payload.getParentId().longValue() != 0) {
            update.set(qdo.parentId, payload.getParentId());
        }
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        if (payload.getAllowChange() != null) {
            update.set(qdo.allowChange, payload.getAllowChange());
        }
        if (payload.getExtString1() != null) {
            update.set(qdo.extString1, payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set(qdo.extString2, payload.getExtString2());
        }
        if (payload.getExtString3() != null) {
            update.set(qdo.extString3, payload.getExtString3());
        }
        if (payload.getExtString4() != null) {
            update.set(qdo.extString4, payload.getExtString4());
        }
        if (payload.getExtString5() != null) {
            update.set(qdo.extString5, payload.getExtString5());
        }
        if (payload.getExtString6() != null) {
            update.set(qdo.extString6, payload.getExtString6());
        }
        if (payload.getExtString7() != null) {
            update.set(qdo.extString7, payload.getExtString7());
        }
        if (payload.getExtString8() != null) {
            update.set(qdo.extString8, payload.getExtString8());
        }
        if (payload.getExtString9() != null) {
            update.set(qdo.extString9, payload.getExtString9());
        }
        if (payload.getExtString10() != null) {
            update.set(qdo.extString10, payload.getExtString10());
        }
        if (payload.getDisabled() != null) {
            update.set(qdo.disabled, payload.getDisabled());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {

//            if (nullFields.contains("remindContent")) {
//                update.setNull(qdo.remindContent);
//            }
//            if (nullFields.contains("remindContentLocale")) {
//                update.setNull(qdo.remindContentLocale);
//            }
            if (nullFields.contains("remark")) {
                update.setNull(qdo.remark);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long delete(List<Long> keys) {
        JPADeleteClause delete = jpaQueryFactory.delete(qdo).where(qdo.id.in(keys));

        return delete.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemSelectionVO queryByKey(Long id) {
        JPAQuery<PrdSystemSelectionVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemSelectionVO> queryPaging(PrdSystemSelectionQuery query) {
        JPAQuery<PrdSystemSelectionVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemSelectionVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemSelectionVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }
}
