package com.elitesland.tw.tw5.server.yeedoc.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.common.TwException;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 附件工具类
 *
 * @author
 * @date
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class FileUtilServiceImpl implements FileUtilService{
    private final YeedocService yeedocService;
    /**
     * 创建文件夹（一个或者多个）
     * @param itemId
     * @param pathArry
     * @param authTokenByYdk
     * @return 易道壳的文件夹的itemId
     */
    @Override
    public String createYdkFolder(String libraryId,String itemId, List<String> pathArry, String authTokenByYdk){
        Map<String, Object> map = new HashMap<>();
        if (StringUtils.hasText(itemId)) {
            map.put("ItemId", itemId);
        }
        map.put("PathArry", pathArry);
        map.put("LibraryId", libraryId);
        log.info("[创建文件夹-易道壳开始]-map:{}", JSONObject.toJSONString(map));
        log.info("[创建文件夹-易道壳开始]-authToken:{}", authTokenByYdk);
        String resultStr = yeedocService.createFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[创建文件夹-易道壳]-map:{}",JSONObject.toJSONString(map));
            log.info("[创建文件夹-易道壳]-resultStr:{}",resultStr);
            throw TwException.error("", "创建文件夹失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[创建文件夹-易道壳返回值]-resultJson:{}",resultJson);
        Object data = resultJson.get("Data");
        if (ObjectUtils.isEmpty(data)) {
            throw TwException.error("", "创建文件夹失败!result = {" + resultJson + "}");
        }
        JSONArray dataArray = JSONArray.parseArray(data.toString());
        String folderId = (String) JSONObject.parseObject(String.valueOf(dataArray.get(0))).get("FolderId");
        if (!StringUtils.hasText(folderId)) {
            throw TwException.error("", "创建文件夹返回值folderId为空!");
        }
        return folderId;
    }

    /**
     * 文件夹重命名
     * @param authTokenByYdk
     * @return 易道壳的文件夹的itemId
     */
    public String reNameFolder(String itemId, String folderName, String authTokenByYdk){
        Map<String, Object> map = new HashMap<>();
        map.put("ItemId", itemId);
        map.put("NewName", folderName);
        log.info("[文件夹重命名-易道壳开始]-map:{}",JSONObject.toJSONString(map));
        log.info("[文件夹重命名-易道壳开始]-authToken:{}",authTokenByYdk);
        String resultStr = yeedocService.reNameFolder(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[文件夹重命名-易道壳]-resultStr:{}",resultStr);
            throw TwException.error("", "文件夹重命名失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[文件夹重命名-易道壳返回值]-resultJson:{}",resultJson);
        if (ObjectUtils.isEmpty(resultJson)) {
            throw TwException.error("", "文件夹重命名失败!result = {" + resultJson + "}");
        }
        JSONObject date = resultJson.getJSONObject("Data");
        if (ObjectUtils.isEmpty(date)) {
            throw TwException.error("", "文件夹重命名失败!result = {" + resultJson + "}");
        }
        String folderId = date.getString("Id");
        if (!StringUtils.hasText(folderId)) {
            throw TwException.error("", "文件夹重命名返回值folderId为空!");
        }
        return folderId;
    }
    /**
     * 最终保存附件
     * @param ydkFolderId
     * @param cacheKeys
     * @return map(cacheKey,itemId)
     */
    @Override
    public Map<String, String> saveYdkFile(String libraryId,String ydkFolderId, Set<String> cacheKeys, String authTokenByYdk){
        Map<String, Object> map = new HashMap<>();
        if (CollectionUtils.isEmpty(cacheKeys)) {
            return null;
        }
        map.put("FolderId", ydkFolderId);
        map.put("LibraryId", libraryId);
        map.put("CacheKey", cacheKeys);
        map.put("ItemList", Lists.newArrayList());
        map.put("AssociatedItemID", Lists.newArrayList());
        map.put("Description", "");
        log.info("[最终保存附件-易道壳开始]-map:{}",JSONObject.toJSONString(map));
        log.info("[最终保存附件-易道壳开始]-authToken:{}",authTokenByYdk);
        String resultStr = yeedocService.newUploadFilesSave(map, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(resultStr)) {
            log.info("[最终保存附件-易道壳]-resultStr:{}",resultStr);
            throw TwException.error("", "最终保存附件失败!result = {" + resultStr + "}");
        }
        JSONObject resultJson = JSONObject.parseObject(resultStr);
        log.info("[最终保存附件-易道壳返回值]-resultJson:{}",resultJson);
        Boolean isSuccess = resultJson.getBoolean("IsSuccess");
        String message = resultJson.getString("Message");
        // todo 易道壳返回的是重复文件名称的，目前重复名称的这种不处理
        if ((!isSuccess) || (!"上传成功！".equals(message))) {
            throw TwException.error("", "最终保存附件失败!result = {" + resultJson + "}");
        }
        // 获取易道壳附件id
        Map<String, Object> getItemMap = new HashMap<>();
        getItemMap.put("CacheKeys", cacheKeys);
        log.info("[获取易道壳附件id-易道壳开始]-map:{}",JSONObject.toJSONString(getItemMap));
        log.info("[获取易道壳附件id-易道壳开始]-authTokenByYdk:{}",authTokenByYdk);
        String itemIdResult = yeedocService.getCaCheKeyItemId(getItemMap, authTokenByYdk);
        if (org.apache.commons.lang3.StringUtils.isEmpty(itemIdResult)) {
            log.info("[获取易道壳附件id-易道壳]-resultStr:{}",itemIdResult);
        }
        JSONObject itemIdResultJson = JSONObject.parseObject(itemIdResult);
        Object itemIdData = itemIdResultJson.get("Data");
        if (ObjectUtils.isEmpty(itemIdData)) {
            throw TwException.error("", "获取易道壳附件id失败!result = {" + resultJson + "}");
        }
        List<JSONObject> itemIdJsonObjectList = JSONArray.parseArray(itemIdData.toString()).toJavaList(JSONObject.class);
        Map<String, String> resultMap = itemIdJsonObjectList.stream().filter(Objects::nonNull).collect(Collectors.toMap(item -> item.getString("CacheKey"), item -> item.getString("ItemId")));
        return resultMap;
    }
}
