package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.RoleStrategyService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/10 10:47
 **/
@Service("ROLE_ASSIGN_ORG_ROLES")
public class RoleAssignOrgRoles implements RoleStrategyService {

    /**
     * 指定组织角色
     *
     * @param rule
     * @param systemRoleCodes
     * @param systemOrgRoleIds
     * @param systemOrgRoleCodes
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, List<String> systemRoleCodes, Set<Long> systemOrgRoleIds, Set<String> systemOrgRoleCodes) {
        return systemOrgRoleIds.contains(Long.parseLong(rule.getRuleScope()));
    }

}
