package com.elitesland.tw.tw5.server.elp.util;

import java.text.MessageFormat;

public class ElpUrlGenerator {

    /**
     * 单点登录地址
     * 生成环境请替换host为v4.21tb.com
     */
    private static String SSO_URL = "https://v4.21tb.com/login/sso.init.do?userName={0}&timestamp={1}&corpCode={2}&sign={3}";

    /**
     * 根据员工工号生成单点登录URL
     *
     * @param userName 登录账户
     * @return 单点登录URL
     * @throws Exception
     */
    public static String generateSSOURL(String userName, String corpCode, String sign) {
        return MessageFormat.format(SSO_URL, userName, System.currentTimeMillis() + "", corpCode, sign);
    }

}
