package com.elitesland.tw.tw5.server.log.service;

import cn.hutool.json.JSONUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.log.query.LogQuery;
import com.elitesland.tw.tw5.api.log.vo.LogVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.log.convert.LogConvert;
import com.elitesland.tw.tw5.server.log.entity.LogDO;
import com.elitesland.tw.tw5.server.log.repo.LogRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.*;

/**
 * 日志记录
 *
 * @author duwh
 * @date 2023-02-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class LogServiceImpl implements LogService {

    private final LogRepo logRepo;

    @Override
    public PagingVO<LogVO> paging(LogQuery query) {
        Page<LogDO> page = logRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(LogConvert.INSTANCE::toVo));
    }

    @Override
    public List<LogVO> queryList(LogQuery query) {
        return LogConvert.INSTANCE.toVoList(logRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public LogDO queryByKey(Long key) {
        LogDO entity = logRepo.findById(key).get();
        return entity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public LogDO insert(LogDO entityDo) {
        return logRepo.save(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public LogDO update(LogDO entityDo) {
        LogDO entity = logRepo.findById(entityDo.getId()).get();
        Assert.notNull(entity.getId(), "不存在");
        entity.copy(entityDo);
        return logRepo.save(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            logRepo.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(ProceedingJoinPoint joinPoint, LogDO log) {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        // 方法路径
        String methodName = joinPoint.getTarget().getClass().getName() + "." + signature.getName() + "()";
        Method method = signature.getMethod();
        log.setAddress(StringUtil.getCityInfo(log.getRequestIp()));
        log.setMethod(methodName);
        log.setParams(getParameter(method, joinPoint.getArgs()));
        logRepo.save(log);
    }

    /**
     * 物理删除
     *
     * @param keys 主键集合
     */
    @Override
    public void delete(List<Long> keys) {
        logRepo.deleteAllById(keys);
    }


    /**
     * 根据方法和传入的参数获取请求参数
     */
    private String getParameter(Method method, Object[] args) {
        List<Object> argList = new ArrayList<>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; i++) {
            //将RequestBody注解修饰的参数作为请求参数
            //RequestBody requestBody = parameters[i].getAnnotation(RequestBody.class);
            //if (requestBody != null) {
            //    argList.add(args[i]);
            //}

            //将RequestParam注解修饰的参数作为请求参数
            /*RequestParam requestParam = parameters[i].getAnnotation(RequestParam.class);
            if (requestParam != null) {
                Map<String, Object> map = new HashMap<>(4);
                String key = parameters[i].getName();
                if (StringUtils.hasText(requestParam.value())) {
                    key = requestParam.value();
                }
                map.put(key, args[i]);
                argList.add(map);
            }*/
            Map<String, Object> map = new HashMap<>(4);
            String key = parameters[i].getName();
            map.put(key, args[i]);
            argList.add(map);
        }
        if (argList.isEmpty()) {
            return "";
        }
        return argList.size() == 1 ? JSONUtil.toJsonStr(argList.get(0)) : JSONUtil.toJsonStr(argList);
    }

}
