package com.elitesland.tw.tw5.server.prd.ab.controller;

import com.elitesland.tw.tw5.api.prd.ab.query.PrdUserAbQuery;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdUserAbService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zoey
 * @Description:
 * @date 2023/8/7 - 17:29
 */
@Api("通讯录管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ab/user")
@Slf4j
public class PrdUserAbController {

    private final PrdUserAbService prdUserAbService;
    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/paging")
    @UdcNameClass
    public TwOutputUtil paging(PrdUserAbQuery query) {
        return TwOutputUtil.ok(prdUserAbService.paging(query));
    }
}
