package com.elitesland.tw.tw5.server.prd.acc.common.functionEnum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.ObjectUtils;

/**
 * @author sunxw
 * @description 费用报销单据类型 ACC:REIM_PROC_KEY
 * @Date 2023/11/23
 */
@Getter
@AllArgsConstructor
public enum AccReimDocTypeEnum {

    ACC_TRIP("ACC_TRIP", "差旅报销单", "ACC_A13"),
    ACC_NOT_TRIP("ACC_NOT_TRIP", "非差旅报销单", "ACC_A12"),
    ACC_TRIP_TICKET("ACC_TRIP_TICKET", "行政订票报销单", "ACC_A24"),
    ACC_SPECIAL("ACC_SPECIAL", "专项报销单", "ACC_A25"),
    ACC_OTHERS("ACC_OTHERS", "特殊费用报销单", "ACC_A27"),
    ACC_OTHERS_SD("ACC_OTHERS_SD", "特殊费用报销单(外包)", "ACC_A28"),
    ;

    private final String code;

    private final String desc;

    /**
     * 流程code
     */
    private final String flowCode;

    /**
     * 根据报销单类型获取枚举实例
     *
     * @param code
     * @return
     */
    public static AccReimDocTypeEnum find(String code) {
        if (ObjectUtils.isEmpty(code)) {
            return null;
        }
        for (AccReimDocTypeEnum docTypeEnum : AccReimDocTypeEnum.values()) {
            if (code.equals(docTypeEnum.getCode())) {
                return docTypeEnum;
            }
        }
        return null;
    }

}
