package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayBatchPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimPayBatchQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimPayBatchService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimPayBatchVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 费用报销记账/付款导出管理
 *
 * @author sunxw
 * @date 2023-12-01
 */
@Api(tags = "费用报销记账/付款导出管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimPayBatch")
@Slf4j
public class AccReimPayBatchController {

    private final AccReimPayBatchService accReimPayBatchService;

    /**
     * 费用报销记账/付款导出管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("费用报销记账/付款导出管理-新增")
    public TwOutputUtil<AccReimPayBatchVO> insert(@RequestBody AccReimPayBatchPayload payload) {
        return TwOutputUtil.ok(accReimPayBatchService.insert(payload));
    }

    /**
     * 费用报销记账/付款导出管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("费用报销记账/付款导出管理-更新")
    public TwOutputUtil<AccReimPayBatchVO> update(@RequestBody AccReimPayBatchPayload payload) {
        return TwOutputUtil.ok(accReimPayBatchService.update(payload));
    }

    /**
     * 费用报销记账/付款导出管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("费用报销记账/付款导出管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimPayBatchPayload payload) {
        return TwOutputUtil.ok(accReimPayBatchService.updateByKeyDynamic(payload));
    }

    /**
     * 费用报销记账/付款导出管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("费用报销记账/付款导出管理-主键查询")
    public TwOutputUtil<AccReimPayBatchVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimPayBatchService.queryByKey(key));
    }

    /**
     * 费用报销记账/付款导出管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("费用报销记账/付款导出管理-分页")
    public TwOutputUtil<PagingVO<AccReimPayBatchVO>> paging(AccReimPayBatchQuery query) {
        return TwOutputUtil.ok(accReimPayBatchService.queryPaging(query));
    }

    /**
     * 费用报销记账/付款导出管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("费用报销记账/付款导出管理-查询列表")
    public TwOutputUtil<List<AccReimPayBatchVO>> queryList(AccReimPayBatchQuery query) {
        return TwOutputUtil.ok(accReimPayBatchService.queryListDynamic(query));
    }

    /**
     * 费用报销记账/付款导出管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("费用报销记账/付款导出管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimPayBatchService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

