package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccBudgetItemPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBudgetItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccBudgetItemDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccBudgetItemDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccBudgetItemRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 预算项目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Repository
@RequiredArgsConstructor
public class AccBudgetItemDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccBudgetItemRepo repo;
    private final QAccBudgetItemDO qdo = QAccBudgetItemDO.accBudgetItemDO;
    private final QAccBudgetItemDO qdo0 = new QAccBudgetItemDO("accBudgetItemDO0");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccBudgetItemVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccBudgetItemVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 预算编码
                qdo.budgetCode,
                // 预算名称
                qdo.budgetName,
                // 上级id
                qdo.parentId,
                // 上级编号
                qdo.parentCode,
                // 科目状态
                qdo.budgetStatus,
                // 级别
                qdo.budgetLevel,
                // 汇总科目（0：否，1：是）
                qdo.sumFlag,
                // 明细账
                qdo.dtlAcc,
                // 处理码
                qdo.procCode,
                // 子账标记
                qdo.ledgerFlag,
                // 子账类型
                qdo.ledgerType,
                // 大类
                qdo.budgetType1,
                // 明细类1
                qdo.budgetType2,
                // 明细类2
                qdo.budgetType3,
                // 可配置字段1
                qdo.extStr1,
                // 可配置字段2
                qdo.extStr2,
                // 可配置字段3
                qdo.extStr3,
                // 可配置字段4
                qdo.extStr4,
                // 可配置字段5
                qdo.extStr5,
                //上级名称
                qdo0.budgetName.as("parentName")
        )).from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccBudgetItemVO> getJpaQueryWhere(AccBudgetItemQuery query) {
        JPAQuery<AccBudgetItemVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccBudgetItemQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo).leftJoin(qdo0).on(qdo.parentId.eq(qdo0.id));
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccBudgetItemQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 预算编码 模糊 */
        if (!ObjectUtils.isEmpty(query.getBudgetCode())) {
            list.add(qdo.budgetCode.like(SqlUtil.toSqlLikeString(query.getBudgetCode())));
        }
        /** 预算名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getBudgetName())) {
            list.add(qdo.budgetName.like(SqlUtil.toSqlLikeString(query.getBudgetName())));
        }
        /** 上级id 精确 */
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            list.add(qdo.parentId.eq(query.getParentId()).or(qdo.id.eq(query.getParentId())));
        }
        /** 上级编号 精确 */
        if (!ObjectUtils.isEmpty(query.getParentCode())) {
            list.add(qdo.parentCode.eq(query.getParentCode()));
        }
        /** 科目状态 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetStatus())) {
            list.add(qdo.budgetStatus.eq(query.getBudgetStatus()));
        }
        /** 级别 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetLevel())) {
            list.add(qdo.budgetLevel.eq(query.getBudgetLevel()));
        }
        /** 汇总科目（0：否，1：是） 精确 */
        if (!ObjectUtils.isEmpty(query.getSumFlag())) {
            list.add(qdo.sumFlag.eq(query.getSumFlag()));
        }
        /** 明细账 精确 */
        if (!ObjectUtils.isEmpty(query.getDtlAcc())) {
            list.add(qdo.dtlAcc.eq(query.getDtlAcc()));
        }
        /** 处理码 精确 */
        if (!ObjectUtils.isEmpty(query.getProcCode())) {
            list.add(qdo.procCode.eq(query.getProcCode()));
        }
        /** 子账标记 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerFlag())) {
            list.add(qdo.ledgerFlag.eq(query.getLedgerFlag()));
        }
        /** 子账类型 精确 */
        if (!ObjectUtils.isEmpty(query.getLedgerType())) {
            list.add(qdo.ledgerType.eq(query.getLedgerType()));
        }
        /** 大类 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetType1())) {
            list.add(qdo.budgetType1.eq(query.getBudgetType1()));
        }
        /** 明细类1 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetType2())) {
            list.add(qdo.budgetType2.eq(query.getBudgetType2()));
        }
        /** 明细类2 模糊 */
        if (!ObjectUtils.isEmpty(query.getBudgetType3())) {
            list.add(qdo.budgetType3.like(SqlUtil.toSqlLikeString(query.getBudgetType3())));
        }
        /** 可配置字段1 模糊 */
        if (!ObjectUtils.isEmpty(query.getExtStr1())) {
            list.add(qdo.extStr1.like(SqlUtil.toSqlLikeString(query.getExtStr1())));
        }
        /** 可配置字段2 模糊 */
        if (!ObjectUtils.isEmpty(query.getExtStr2())) {
            list.add(qdo.extStr2.like(SqlUtil.toSqlLikeString(query.getExtStr2())));
        }
        /** 可配置字段3 模糊 */
        if (!ObjectUtils.isEmpty(query.getExtStr3())) {
            list.add(qdo.extStr3.like(SqlUtil.toSqlLikeString(query.getExtStr3())));
        }
        /** 可配置字段4 模糊 */
        if (!ObjectUtils.isEmpty(query.getExtStr4())) {
            list.add(qdo.extStr4.like(SqlUtil.toSqlLikeString(query.getExtStr4())));
        }
        /** 可配置字段5 模糊 */
        if (!ObjectUtils.isEmpty(query.getExtStr5())) {
            list.add(qdo.extStr5.like(SqlUtil.toSqlLikeString(query.getExtStr5())));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccBudgetItemVO queryByKey(Long id) {
        JPAQuery<AccBudgetItemVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccBudgetItemVO> queryListDynamic(AccBudgetItemQuery query) {
        JPAQuery<AccBudgetItemVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccBudgetItemVO> queryPaging(AccBudgetItemQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccBudgetItemVO> jpaQuery = getJpaQueryWhere(query);
        List<AccBudgetItemVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccBudgetItemVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccBudgetItemDO save(AccBudgetItemDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccBudgetItemDO> saveAll(List<AccBudgetItemDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccBudgetItemPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 预算编码
        if (payload.getBudgetCode() != null) {
            update.set(qdo.budgetCode, payload.getBudgetCode());
        }
        // 预算名称
        if (payload.getBudgetName() != null) {
            update.set(qdo.budgetName, payload.getBudgetName());
        }
        // 上级id
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        // 上级编号
        if (payload.getParentCode() != null) {
            update.set(qdo.parentCode, payload.getParentCode());
        }
        // 科目状态
        if (payload.getBudgetStatus() != null) {
            update.set(qdo.budgetStatus, payload.getBudgetStatus());
        }
        // 级别
        if (payload.getBudgetLevel() != null) {
            update.set(qdo.budgetLevel, payload.getBudgetLevel());
        }
        // 汇总科目（0：否，1：是）
        if (payload.getSumFlag() != null) {
            update.set(qdo.sumFlag, payload.getSumFlag());
        }
        // 明细账
        if (payload.getDtlAcc() != null) {
            update.set(qdo.dtlAcc, payload.getDtlAcc());
        }
        // 处理码
        if (payload.getProcCode() != null) {
            update.set(qdo.procCode, payload.getProcCode());
        }
        // 子账标记
        if (payload.getLedgerFlag() != null) {
            update.set(qdo.ledgerFlag, payload.getLedgerFlag());
        }
        // 子账类型
        if (payload.getLedgerType() != null) {
            update.set(qdo.ledgerType, payload.getLedgerType());
        }
        // 大类
        if (payload.getBudgetType1() != null) {
            update.set(qdo.budgetType1, payload.getBudgetType1());
        }
        // 明细类1
        if (payload.getBudgetType2() != null) {
            update.set(qdo.budgetType2, payload.getBudgetType2());
        }
        // 明细类2
        if (payload.getBudgetType3() != null) {
            update.set(qdo.budgetType3, payload.getBudgetType3());
        }
        // 可配置字段1
        if (payload.getExtStr1() != null) {
            update.set(qdo.extStr1, payload.getExtStr1());
        }
        // 可配置字段2
        if (payload.getExtStr2() != null) {
            update.set(qdo.extStr2, payload.getExtStr2());
        }
        // 可配置字段3
        if (payload.getExtStr3() != null) {
            update.set(qdo.extStr3, payload.getExtStr3());
        }
        // 可配置字段4
        if (payload.getExtStr4() != null) {
            update.set(qdo.extStr4, payload.getExtStr4());
        }
        // 可配置字段5
        if (payload.getExtStr5() != null) {
            update.set(qdo.extStr5, payload.getExtStr5());
        }
        // 备注
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 预算编码
            if (nullFields.contains("budgetCode")) {
                update.setNull(qdo.budgetCode);
            }
            // 预算名称
            if (nullFields.contains("budgetName")) {
                update.setNull(qdo.budgetName);
            }
            // 上级id
            if (nullFields.contains("parentId")) {
                update.setNull(qdo.parentId);
            }
            // 上级编号
            if (nullFields.contains("parentCode")) {
                update.setNull(qdo.parentCode);
            }
            // 科目状态
            if (nullFields.contains("budgetStatus")) {
                update.setNull(qdo.budgetStatus);
            }
            // 级别
            if (nullFields.contains("budgetLevel")) {
                update.setNull(qdo.budgetLevel);
            }
            // 汇总科目（0：否，1：是）
            if (nullFields.contains("sumFlag")) {
                update.setNull(qdo.sumFlag);
            }
            // 明细账
            if (nullFields.contains("dtlAcc")) {
                update.setNull(qdo.dtlAcc);
            }
            // 处理码
            if (nullFields.contains("procCode")) {
                update.setNull(qdo.procCode);
            }
            // 子账标记
            if (nullFields.contains("ledgerFlag")) {
                update.setNull(qdo.ledgerFlag);
            }
            // 子账类型
            if (nullFields.contains("ledgerType")) {
                update.setNull(qdo.ledgerType);
            }
            // 大类
            if (nullFields.contains("budgetType1")) {
                update.setNull(qdo.budgetType1);
            }
            // 明细类1
            if (nullFields.contains("budgetType2")) {
                update.setNull(qdo.budgetType2);
            }
            // 明细类2
            if (nullFields.contains("budgetType3")) {
                update.setNull(qdo.budgetType3);
            }
            // 可配置字段1
            if (nullFields.contains("extStr1")) {
                update.setNull(qdo.extStr1);
            }
            // 可配置字段2
            if (nullFields.contains("extStr2")) {
                update.setNull(qdo.extStr2);
            }
            // 可配置字段3
            if (nullFields.contains("extStr3")) {
                update.setNull(qdo.extStr3);
            }
            // 可配置字段4
            if (nullFields.contains("extStr4")) {
                update.setNull(qdo.extStr4);
            }
            // 可配置字段5
            if (nullFields.contains("extStr5")) {
                update.setNull(qdo.extStr5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据编号或者名称查询
     *
     * @param budgetCode
     * @param budgetName
     * @return
     */
    public List<Long> queryByCodeAndName(String budgetCode, String budgetName) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.id).from(qdo).where(qdo.deleteFlag.eq(0)).
                where(qdo.budgetCode.eq(budgetCode).and(qdo.budgetName.eq(budgetName)));
        return jpaQuery.fetch();
    }
}

