package com.elitesland.tw.tw5.server.prd.acc.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccSubjectTemplateDetailPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccSubjectTemplateDetailQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccSubjectTemplateDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.*;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccSubjectTemplateDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 科目模板明细管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Repository
@RequiredArgsConstructor
public class AccSubjectTemplateDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccSubjectTemplateDetailRepo repo;
    private final QAccSubjectTemplateDetailDO qdo = QAccSubjectTemplateDetailDO.accSubjectTemplateDetailDO;
    private final QAccFinancialSubjectDO qdoFinancialSubject = QAccFinancialSubjectDO.accFinancialSubjectDO;
    private final QAccBusinessItemDO qdoBusinessItem = QAccBusinessItemDO.accBusinessItemDO;
    private final QAccBudgetItemDO qdoBudgetItem = QAccBudgetItemDO.accBudgetItemDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccSubjectTemplateDetailVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(AccSubjectTemplateDetailVO.class,
                        qdo.id,
                        qdo.remark,
                        qdo.createUserId,
                        qdo.creator,
                        qdo.createTime,
                        qdo.modifyUserId,
                        qdo.updater,
                        qdo.modifyTime,
                        // 模板id
                        qdo.tmplId,
                        // 核算项目id
                        qdo.businessId,
                        qdoBusinessItem.parentId,
                        qdoBusinessItem.businessName,
                        qdoBusinessItem.businessCode,
                        // 预算项目id
                        qdo.budgetId,
                        qdoBudgetItem.budgetName,
                        // 会计科目id
                        qdo.accId,
                        qdoFinancialSubject.accName,
                        // 是否考核
                        qdo.examineFlag,
                        // 是否包含
                        qdo.includeFlag,
                        //是否控制
                        qdo.controlFlag,
                        // 处理状态
                        qdo.procStatus,
                        // 处理信息
                        qdo.procInfo,
                        // 处理时间
                        qdo.procTime,
                        // 可配置字段1
                        qdo.extStr1,
                        // 可配置字段2
                        qdo.extStr2,
                        // 可配置字段3
                        qdo.extStr3,
                        // 可配置字段4
                        qdo.extStr4,
                        // 可配置字段5
                        qdo.extStr5,
                        // 税率
                        qdoBusinessItem.taxRate
                )).from(qdo).leftJoin(qdoBusinessItem).on(qdo.businessId.eq(qdoBusinessItem.id).and(qdoBusinessItem.deleteFlag.eq(0)))
                .leftJoin(qdoBudgetItem).on(qdoBudgetItem.id.eq(qdo.budgetId).and(qdoBudgetItem.deleteFlag.eq(0)))
                .leftJoin(qdoFinancialSubject).on(qdoFinancialSubject.id.eq(qdo.accId).and(qdoFinancialSubject.deleteFlag.eq(0)));
    }

    /**
     * 通过模板主键查询
     *
     * @param tmplId 查询参数
     * @return 结果集合
     */
    public List<AccSubjectTemplateDetailVO> queryListByTmplId(Long tmplId) {
        AccSubjectTemplateDetailQuery query = new AccSubjectTemplateDetailQuery();
        query.setTmplId(tmplId);
        JPAQuery<AccSubjectTemplateDetailVO> jpaQuery = getJpaQuerySelect0();
        // 条件封装
        jpaQuery.where(where(query));
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccSubjectTemplateDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccSubjectTemplateDetailVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 模板id
                qdo.tmplId,
                // 核算项目id
                qdo.businessId,
                // 预算项目id
                qdo.budgetId,
                // 会计科目id
                qdo.accId,
                // 是否考核
                qdo.examineFlag,
                // 是否包含
                qdo.includeFlag,
                // 处理状态
                qdo.procStatus,
                //是否控制
                qdo.controlFlag,
                // 处理信息
                qdo.procInfo,
                // 处理时间
                qdo.procTime,
                // 可配置字段1
                qdo.extStr1,
                // 可配置字段2
                qdo.extStr2,
                // 可配置字段3
                qdo.extStr3,
                // 可配置字段4
                qdo.extStr4,
                // 可配置字段5
                qdo.extStr5
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccSubjectTemplateDetailVO> getJpaQueryWhere(AccSubjectTemplateDetailQuery query) {
        JPAQuery<AccSubjectTemplateDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccSubjectTemplateDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccSubjectTemplateDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 模板id 精确 */
        if (!ObjectUtils.isEmpty(query.getTmplId())) {
            list.add(qdo.tmplId.eq(query.getTmplId()));
        }
        /** 核算项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessId())) {
            list.add(qdo.businessId.eq(query.getBusinessId()));
        }
        /** 预算项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getBudgetId())) {
            list.add(qdo.budgetId.eq(query.getBudgetId()));
        }
        /** 会计科目id 精确 */
        if (!ObjectUtils.isEmpty(query.getAccId())) {
            list.add(qdo.accId.eq(query.getAccId()));
        }
        /** 是否考核 精确 */
        if (!ObjectUtils.isEmpty(query.getExamineFlag())) {
            list.add(qdo.examineFlag.eq(query.getExamineFlag()));
        }
        /** 是否包含 精确 */
        if (!ObjectUtils.isEmpty(query.getIncludeFlag())) {
            list.add(qdo.includeFlag.eq(query.getIncludeFlag()));
        }
        /** 处理状态 精确 */
        if (!ObjectUtils.isEmpty(query.getProcStatus())) {
            list.add(qdo.procStatus.eq(query.getProcStatus()));
        }
        /** 处理信息 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInfo())) {
            list.add(qdo.procInfo.eq(query.getProcInfo()));
        }
        /** 处理时间 精确 */
        if (!ObjectUtils.isEmpty(query.getProcTime())) {
            list.add(qdo.procTime.eq(query.getProcTime()));
        }
        /** 可配置字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr1())) {
            list.add(qdo.extStr1.eq(query.getExtStr1()));
        }
        /** 可配置字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr2())) {
            list.add(qdo.extStr2.eq(query.getExtStr2()));
        }
        /** 可配置字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr3())) {
            list.add(qdo.extStr3.eq(query.getExtStr3()));
        }
        /** 可配置字段4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr4())) {
            list.add(qdo.extStr4.eq(query.getExtStr4()));
        }
        /** 可配置字段5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr5())) {
            list.add(qdo.extStr5.eq(query.getExtStr5()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccSubjectTemplateDetailVO queryByKey(Long id) {
        JPAQuery<AccSubjectTemplateDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccSubjectTemplateDetailVO> queryListDynamic(AccSubjectTemplateDetailQuery query) {
        JPAQuery<AccSubjectTemplateDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccSubjectTemplateDetailVO> queryPaging(AccSubjectTemplateDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AccSubjectTemplateDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<AccSubjectTemplateDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccSubjectTemplateDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccSubjectTemplateDetailDO save(AccSubjectTemplateDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccSubjectTemplateDetailDO> saveAll(List<AccSubjectTemplateDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccSubjectTemplateDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 模板id
        if (payload.getTmplId() != null) {
            update.set(qdo.tmplId, payload.getTmplId());
        }
        // 核算项目id
        if (payload.getBusinessId() != null) {
            update.set(qdo.businessId, payload.getBusinessId());
        }
        // 预算项目id
        if (payload.getBudgetId() != null) {
            update.set(qdo.budgetId, payload.getBudgetId());
        }
        // 会计科目id
        if (payload.getAccId() != null) {
            update.set(qdo.accId, payload.getAccId());
        }
        // 是否考核
        if (payload.getExamineFlag() != null) {
            update.set(qdo.examineFlag, payload.getExamineFlag());
        }
        // 是否控制
        if (payload.getControlFlag() != null) {
            update.set(qdo.controlFlag, payload.getControlFlag());
        }
        // 是否包含
        if (payload.getIncludeFlag() != null) {
            update.set(qdo.includeFlag, payload.getIncludeFlag());
        }
        // 处理状态
        if (payload.getProcStatus() != null) {
            update.set(qdo.procStatus, payload.getProcStatus());
        }
        // 处理信息
        if (payload.getProcInfo() != null) {
            update.set(qdo.procInfo, payload.getProcInfo());
        }
        // 处理时间
        if (payload.getProcTime() != null) {
            update.set(qdo.procTime, payload.getProcTime());
        }
        // 可配置字段1
        if (payload.getExtStr1() != null) {
            update.set(qdo.extStr1, payload.getExtStr1());
        }
        // 可配置字段2
        if (payload.getExtStr2() != null) {
            update.set(qdo.extStr2, payload.getExtStr2());
        }
        // 可配置字段3
        if (payload.getExtStr3() != null) {
            update.set(qdo.extStr3, payload.getExtStr3());
        }
        // 可配置字段4
        if (payload.getExtStr4() != null) {
            update.set(qdo.extStr4, payload.getExtStr4());
        }
        // 可配置字段5
        if (payload.getExtStr5() != null) {
            update.set(qdo.extStr5, payload.getExtStr5());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 模板id
            if (nullFields.contains("tmplId")) {
                update.setNull(qdo.tmplId);
            }
            // 核算项目id
            if (nullFields.contains("businessId")) {
                update.setNull(qdo.businessId);
            }
            // 预算项目id
            if (nullFields.contains("budgetId")) {
                update.setNull(qdo.budgetId);
            }
            // 会计科目id
            if (nullFields.contains("accId")) {
                update.setNull(qdo.accId);
            }
            // 是否考核
            if (nullFields.contains("examineFlag")) {
                update.setNull(qdo.examineFlag);
            }
            // 是否包含
            if (nullFields.contains("includeFlag")) {
                update.setNull(qdo.includeFlag);
            }
            // 处理状态
            if (nullFields.contains("procStatus")) {
                update.setNull(qdo.procStatus);
            }
            // 处理信息
            if (nullFields.contains("procInfo")) {
                update.setNull(qdo.procInfo);
            }
            // 处理时间
            if (nullFields.contains("procTime")) {
                update.setNull(qdo.procTime);
            }
            // 可配置字段1
            if (nullFields.contains("extStr1")) {
                update.setNull(qdo.extStr1);
            }
            // 可配置字段2
            if (nullFields.contains("extStr2")) {
                update.setNull(qdo.extStr2);
            }
            // 可配置字段3
            if (nullFields.contains("extStr3")) {
                update.setNull(qdo.extStr3);
            }
            // 可配置字段4
            if (nullFields.contains("extStr4")) {
                update.setNull(qdo.extStr4);
            }
            // 可配置字段5
            if (nullFields.contains("extStr5")) {
                update.setNull(qdo.extStr5);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据模板id查询核算项目id
     *
     * @param temlId
     * @return
     */
    public List<Long> queryBusinessIdList(Long temlId) {
        JPAQuery<Long> where = jpaQueryFactory.select(qdo.businessId).from(qdo).where(qdo.tmplId.eq(temlId));
        return where.fetch();
    }

    /**
     * 根据模板id逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoftByTemlIds(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.tmplId.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }


    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccBudgetItemVO> getJpaQuerySelect1() {
        return jpaQueryFactory.select(Projections.bean(AccBudgetItemVO.class,
                qdoBudgetItem.id,
                // 预算编码
                qdoBudgetItem.budgetCode,
                // 预算名称
                qdoBudgetItem.budgetName,
                // 上级id
                qdoBudgetItem.parentId,
                // 上级编号
                qdoBudgetItem.parentCode,
                // 科目状态
                qdoBudgetItem.budgetStatus

        )).from(qdoBudgetItem).leftJoin(qdo).on(qdo.budgetId.eq(qdoBudgetItem.id));
    }

    /**
     * 动态查询集合
     *
     * @param tmplId 模板id
     * @return 结果集合
     */
    public List<AccBudgetItemVO> queryBudgetItemList(Long tmplId) {
        JPAQuery<AccBudgetItemVO> jpaQuery = getJpaQuerySelect1();
        List<Predicate> list = new ArrayList<>();
        list.add(qdo.deleteFlag.eq(0));
        list.add(qdo.tmplId.eq(tmplId));
        list.add(qdoBudgetItem.budgetStatus.eq("ACTIVE"));
        jpaQuery.where(ExpressionUtils.allOf(list));
        jpaQuery.groupBy(qdoBudgetItem.id);
        return jpaQuery.fetch();
    }

}

