package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmTripTicketQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmTripTicketService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmTripTicketVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmBusitripApplyConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmBusitripApplyDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmBusitripApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmBusitripApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BusitripApplyStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AdmBusitripApplyServiceImpl extends BaseServiceImpl implements AdmBusitripApplyService {

    private final AdmBusitripApplyRepo admBusitripApplyRepo;
    private final AdmBusitripApplyDAO admBusitripApplyDAO;
    private final AdmBusitripApplyDetailService admBusitripApplyDetailService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final PrdSystemRoleService roleService;
    private final AdmTripTicketService admTripTicketService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmBusitripApplyVO insertOrUpdate(AdmBusitripApplyPayload payload) {
        // 数据校验
        AdmBusitripApplyVO admBusitripApplyVO = checkData(payload);

        String appName = "";
        Long pmResId = 0L;
        Long deliUserId = 0L;
        Long deliBuId = 0L;
        Long preSaleUserId = 0L;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = pmsProjectService.queryByKey(payload.getReasonId());
            if (payload.getExpenseBuId() == null) {
                payload.setExpenseBuId(pmsProjectVO.getDeliBuId());
            }
            appName = pmsProjectVO.getProjName();
            pmResId = pmsProjectVO.getPmResId();
            deliUserId = pmsProjectVO.getDeliUserId();
            deliBuId = pmsProjectVO.getDeliBuId();
        }
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = buProjectService.queryByKey(payload.getReasonId());
            if (payload.getExpenseBuId() == null) {
                payload.setExpenseBuId(buProjectVO.getDeliBuId());
            }
            appName = buProjectVO.getProjName();
            pmResId = buProjectVO.getPmResId();
            deliUserId = buProjectVO.getDeliUserId();
            PrdOrgOrganizationVO org = cacheUtil.getOrg(buProjectVO.getDeliBuId());
            if (org != null) {
                preSaleUserId = org.getManageId();
            }
        }
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            CrmOpportunityQuery query = new CrmOpportunityQuery();
            query.setProjectId(payload.getReasonId());
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(crmOpportunityListVOS)) {
                if (payload.getExpenseBuId() == null) {
                    payload.setExpenseBuId(cacheUtil.getDefaultOrgIdByUserId(payload.getApplyResId()));
                }
                appName = crmOpportunityListVOS.get(0).getProjectName();
                PrdOrgOrganizationVO org = cacheUtil.getOrg(crmOpportunityListVOS.get(0).getPreSaleOrgId());
                if (org != null) {
                    preSaleUserId = org.getManageId();
                }
            } else {
                throw TwException.error("", "事由不存在");
            }

        }
        if (admBusitripApplyVO == null) {
            String code = generateSeqNum("AMD_BUSITRIP_APPLY");
            payload.setApplyNo(code);
            payload.setApplyDate(LocalDate.now());
            payload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
        } else {
            payload.setApplyStatus(admBusitripApplyVO.getApplyStatus());
            payload.setProcInstId(admBusitripApplyVO.getProcInstId());
            payload.setApplyDate(admBusitripApplyVO.getApplyDate());
        }
        AdmBusitripApplyDO entityDo = AdmBusitripApplyConvert.INSTANCE.toDo(payload);
        AdmBusitripApplyDO save = admBusitripApplyRepo.save(entityDo);
        //删除明细
        if (!ObjectUtils.isEmpty(payload.getDelDetailIds())) {
            admBusitripApplyDetailService.deleteSoft(payload.getDelDetailIds());
        }
        //批量保存明细
        if (!ObjectUtils.isEmpty(payload.getDetailPayloads())) {
            payload.getDetailPayloads().forEach(act -> act.setApplyId(save.getId()));
            admBusitripApplyDetailService.bacthInsert(payload.getDetailPayloads());
        } else {
            if (admBusitripApplyVO == null) {
                throw TwException.error("", "出差人明细信息");
            }
        }

        String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        String applyStatus = BusitripApplyStatusEnum.APPLYING.getCode();
        String procInstId = null;
        if (admBusitripApplyVO != null) {
            procInstId = admBusitripApplyVO.getProcInstId();
        }
        //获取流程参数
        HashMap<String, Object> variables = getVariables(payload, pmResId, deliUserId, deliBuId, preSaleUserId);
        if (procInstId == null) {
            String procName = "";//流程名称
            // if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            procName = "A05.出差申请-" + cacheUtil.getUserName(payload.getApplyResId()) + "-"
                    + appName + "-" + payload.getBeginDate() + "~" + payload.getEndDate();
            // }
            //新建审批流
            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    "AMD_BUSITRIP_APPLY",
                    procName,
                    entityDo.getId() + "",
                    variables)
            );
            procInstId = processInfo.getProcInstId();
            apprStatus = processInfo.getProcInstStatus().name();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                applyStatus = BusitripApplyStatusEnum.APPROVED.getCode();
                procInstId = null;
            }
        } else {
            Integer rejectType = admBusitripApplyVO.getRejectType();
            //是否行政驳回提交到提交人
            variables.put("rejectType", (rejectType == null || rejectType == 0) ? false : true);
            //修改流程实例节点审批人
            workflowUtil.setVariables(SetVariablesPayload.of(procInstId, variables));
        }
        AdmBusitripApplyPayload payload0 = new AdmBusitripApplyPayload();
        payload0.setId(entityDo.getId());
        payload0.setProcInstId(procInstId);
        payload0.setApprStatus(apprStatus);
        payload0.setApplyStatus(applyStatus);
        //payload0.setNullFields(List.of("procInstId"));
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            admBusitripApplyDAO.updateByKeyDynamic(payload0);
        });
        return AdmBusitripApplyConvert.INSTANCE.toVo(save);
    }

    /**
     * 获取流程参数
     *
     * @param payload
     * @return
     */
    HashMap<String, Object> getVariables(AdmBusitripApplyPayload payload, Long pmResId, Long deliUserId, Long deliBuId, Long preSaleUserId) {
        if (null == pmResId) {
            throw TwException.error("", "项目经理未设置");
        }
        if (null == deliUserId) {
            throw TwException.error("", "交付负责人未设置");
        }
        //    PrdOrgOrganizationVO org = cacheUtil.getOrg(payload.getExpenseBuId());
        //新建审批流
        HashMap<String, Object> batchMap = new HashMap<>();

        //是否行政驳回提交到提交人
        batchMap.put("rejectType", false);
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(payload.getApplyResId());
        //是否内部员工
        batchMap.put("insideRes", true);
        if (StringUtils.hasText(employee.getExtString6()) && employee.getExtString6().equals("EXTERNAL_RES")) {
            batchMap.put("insideRes", false);
        }
        //直属上级
        batchMap.put("Activity_1vc7jrp", Lists.newArrayList(userDefaultOrg.getParentId()));
        //事由类型
        batchMap.put("reasonType", payload.getReasonType());
        //费用承担BU负责人审批
        batchMap.put("Activity_1t8iywq", Lists.newArrayList(preSaleUserId));

        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            Boolean managerFlag = pmResId.equals(payload.getApplyResId());//申请人是否是项目经理
            Boolean deliUserFlag = deliUserId.equals(payload.getApplyResId());//申请人是否是交付负责人
            Boolean deliBuFlag = userDefaultOrg.getManageId().equals(payload.getApplyResId());//申请人是否是交付BU负责人
            batchMap.put("managerFlag", managerFlag);
            batchMap.put("deliUserFlag", deliUserFlag);
            batchMap.put("deliBuFlag", deliBuFlag);
        }
        Boolean ticketFlag = false;
        if (payload.getBookTicketFlag() != null && payload.getBookTicketFlag() == 1) {
            ticketFlag = true;
        }
        //项目经理审批
        batchMap.put("Activity_09w2nl2", Lists.newArrayList(pmResId));
        //交付负责人审批
        batchMap.put("Activity_09sx2tb", Lists.newArrayList(deliUserId));
        //项目交付BU负责人审批
        PrdOrgOrganizationVO org = cacheUtil.getOrg(deliBuId);
        batchMap.put("Activity_1qhep9c", Lists.newArrayList(0L));
        if (org != null) {
            batchMap.put("Activity_1qhep9c", Lists.newArrayList(org.getManageId()));
        }

        //行政订票
        batchMap.put("ticketFlag", ticketFlag);
        //平台行政订票专员（项目）
        batchMap.put("Activity_0i0aafe", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_TICKET_ASSIS_PROJ.getCode()));
        //平台行政订票专员（非项目）
        batchMap.put("Activity_1ft0fbg", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_TICKET_ASSIS.getCode()));

        return batchMap;
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    AdmBusitripApplyVO checkData(AdmBusitripApplyPayload payload) {
        if (!StringUtils.hasText(payload.getReasonType())) {
            throw TwException.error("", "事由类型不可为空，请核验！");
        }
        if (payload.getReasonId() == null) {
            throw TwException.error("", "归属事由不可为空，请核验！");
        }
        if (!StringUtils.hasText(payload.getReasonName())) {
            throw TwException.error("", "归属事由名称不可为空，请核验！");
        }
        if (!payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            if (payload.getExpenseBuId() == null) {
                throw TwException.error("", "费用承担bu不可为空");
            }
        }
        if (payload.getApplyResId() == null) {
            throw TwException.error("", "申请人不可为空，请核验！");
        }
        //赋值bu id
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        payload.setApplyBuId(userDefaultOrg.getOrgId());
        AdmBusitripApplyVO admBusitripApplyVO = null;
        if (payload.getId() != null) {
            admBusitripApplyVO = admBusitripApplyDAO.queryByKey(payload.getId());
            if (admBusitripApplyVO == null) {
                throw TwException.error("", "修改数据不存在");
            }
            if (!admBusitripApplyVO.getApplyStatus().equals(BusitripApplyStatusEnum.CREATE.getCode()) && !admBusitripApplyVO.getApplyStatus().equals(BusitripApplyStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "仅支持新建或已拒绝状态修改");
            }
        }
        return admBusitripApplyVO;
    }

    @Override
    public PagingVO<AdmBusitripApplyVO> queryPaging(AdmBusitripApplyQuery query) {
        PagingVO<AdmBusitripApplyVO> result = admBusitripApplyDAO.queryPaging(query);
        result.stream().forEach(e -> e.setCustName(cacheUtil.getCompanyNameByBookId(e.getCustId())));
        return result;
    }

    @Override
    public List<AdmBusitripApplyVO> queryListDynamic(AdmBusitripApplyQuery query) {
        List<AdmBusitripApplyVO> admBusitripApplyVOS = admBusitripApplyDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(admBusitripApplyVOS)) {
            List<Long> reasonIds = admBusitripApplyVOS.stream().filter(item -> item.getReasonId() != null && StringUtils.hasText(item.getReasonType()) && item.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())).map(p -> p.getReasonId()).collect(Collectors.toList());
            Map<Long, List<PmsProjectVO>> pmsProjectVOMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(reasonIds)) {
                List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryListByReasonIdList(reasonIds);
                if (!CollectionUtils.isEmpty(pmsProjectVOS)) {
                    pmsProjectVOMap = pmsProjectVOS.stream().collect(Collectors.groupingBy(PmsProjectVO::getId));
                }
            }
            final Map<Long, List<PmsProjectVO>> finalPmsProjectVOMap = pmsProjectVOMap;
            admBusitripApplyVOS.forEach(
                    vo -> {
                        vo.setOuName(cacheUtil.getCompanyNameByBookId(vo.getOuId()));
                        vo.setCustName(cacheUtil.getCompanyNameByBookId(vo.getCustId()));
                        if (!CollectionUtils.isEmpty(finalPmsProjectVOMap)) {
                            if (finalPmsProjectVOMap.containsKey(vo.getReasonId())) {
                                vo.setRecvedAmt(finalPmsProjectVOMap.get(vo.getReasonId()).get(0).getRecvedAmt());
                                vo.setPlatType(finalPmsProjectVOMap.get(vo.getReasonId()).get(0).getPlatType());
                                vo.setProjStatus(finalPmsProjectVOMap.get(vo.getReasonId()).get(0).getProjStatus());
                            }
                        }
                    }
            );
        }
        return admBusitripApplyVOS;
    }

    @Override
    public AdmBusitripApplyVO queryByKey(Long key) {
        AdmBusitripApplyVO admBusitripApplyVO = admBusitripApplyDAO.queryByKey(key);
        admBusitripApplyVO.setCustName(cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getCustId()));
        AdmBusitripApplyDetailQuery queryDetail = new AdmBusitripApplyDetailQuery();
        queryDetail.setApplyId(key);
        List<AdmBusitripApplyDetailVO> admBusitripApplyDetailVOS = admBusitripApplyDetailService.queryListDynamic(queryDetail);

        AdmTripTicketQuery query = new AdmTripTicketQuery();
        query.setApplyId(key);
        List<AdmTripTicketVO> admTripTicketVOS = admTripTicketService.queryListDynamic(query);

        String companyName = cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getOuId());
        admBusitripApplyVO.setOuName(companyName);
        admBusitripApplyVO.setCustName(cacheUtil.getCompanyNameByBookId(admBusitripApplyVO.getCustId()));
        admBusitripApplyVO.setDetailVOs(admBusitripApplyDetailVOS);
        admBusitripApplyVO.setTripTicketVOs(admTripTicketVOS);
        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(admBusitripApplyVO.getApplyResId());
        String applyResLevel = "";
        if (employee != null) {
            applyResLevel = employee.getExtString1();
        }
        admBusitripApplyVO.setApplyResLevel(applyResLevel);
        // 如果apply_bu_id 是空 就查询下
        if (admBusitripApplyVO.getApplyBuId() == null) {
            // 获取申请人的默认bu
            Long defaultOrgIdByUserId = cacheUtil.getDefaultOrgIdByUserId(admBusitripApplyVO.getApplyResId());
            admBusitripApplyVO.setApplyBuId(defaultOrgIdByUserId);
        }
        return admBusitripApplyVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmBusitripApplyVO update(AdmBusitripApplyPayload payload) {
        //   long l = admBusitripApplyDAO.updateByKeyDynamic(payload);
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AdmBusitripApplyPayload payload) {
        long result = admBusitripApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<AdmBusitripApplyVO> admBusitripApplyVOS = admBusitripApplyDAO.queryByKeys(keys);
            if (!ObjectUtils.isEmpty(admBusitripApplyVOS)) {
                Long loginUserId = GlobalUtil.getLoginUserId();
                admBusitripApplyVOS.forEach(vo -> {
                    if (!vo.getApplyStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                        throw TwException.error("", "仅支持新建状态的删除");
                    }
                    try {
                        //删除流程
                        if (StringUtils.hasText(vo.getProcInstId())) {
                            workflowUtil.deleteProcess(DeleteProcessPayload.of(vo.getProcInstId(), ""));
                        }
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                //删除出差数据
                admBusitripApplyDAO.deleteSoft(keys);
                //删除明细数据
                admBusitripApplyDetailService.deleteSoftByApplyId(keys);
            }
        }
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        AdmBusitripApplyVO admBusitripApplyVO = admBusitripApplyDAO.queryByKey(Long.valueOf(businessKey));


        if (admBusitripApplyVO != null) {
            AdmBusitripApplyPayload busitripApplyPayload = new AdmBusitripApplyPayload();
            busitripApplyPayload.setId(Long.parseLong(businessKey));
            busitripApplyPayload.setApprStatus(procInstStatus.name());
            int rejectType = 0;
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //taskAuthorizedPayload.setApprStatus(procInstStatus.name());
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //  taskAuthorizedPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    busitripApplyPayload.setProcInstId(null);
                    busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    busitripApplyPayload.setDeleteFlag(1);
                    //taskAuthorizedPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.CREATE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    //  taskAuthorizedPayload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.REJECTED.getCode());
                    String taskDefKey = payload.getCommentInfo().getTaskDefKey();
                    if (taskDefKey.equals("Activity_0i0aafe") || taskDefKey.equals("Activity_1ft0fbg")) {
                        //行政驳回
                        rejectType = 1;
                    }
                    break;
                case APPROVED:
                    //   taskAuthorizedPayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    //  busitripApplyPayload.setProcInstId(null);
                    // busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.APPROVED.getCode());
                    break;
                case APPROVING:
                    busitripApplyPayload.setApplyStatus(BusitripApplyStatusEnum.APPLYING.getCode());
                    break;
            }
            busitripApplyPayload.setRejectType(rejectType);
            admBusitripApplyDAO.updateByKeyDynamic(busitripApplyPayload);

        }
    }

    @Override
    public AdmBusitripApplyVO queryOneByKey(Long key) {
        return admBusitripApplyDAO.queryByKey(key);
    }

    @Override
    public void unbindReim(Long reimId) {
        admBusitripApplyDAO.unbindReim(reimId);
    }

}
