package com.elitesland.tw.tw5.server.prd.budget.controller;


import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.*;


/**
 * 预算拨付基本信息
 *
 * @author xxb
 * @date 2023-11-01
 */
@Api(tags = "预算拨付基本信息--2.0")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/budget/appropriation")
@Slf4j
public class BudgetAppropriationController {

    private final BudgetAppropriationService budgetAppropriationService;

    /**
     * 预算拨付基本信息-新增新增/更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping("save")
    @ApiOperation("预算拨付基本信息-新增/更新")
    @GlobalTransactional
    public TwOutputUtil<BudgetAppropriationVO> save(@RequestBody BudgetAppropriationPayload payload){
        budgetAppropriationService.save(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 预算拨付基本信息-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
     @UdcNameClass
    @ApiOperation("预算拨付基本信息-主键查询")
    public TwOutputUtil<BudgetAppropriationVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(budgetAppropriationService.queryByKey(key));
    }

    /**
     * 预算拨付基本信息-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
     @UdcNameClass
    @ApiOperation("预算拨付基本信息-分页")
    public TwOutputUtil<PagingVO<BudgetAppropriationVO>>  paging(BudgetAppropriationQuery query) {
        return TwOutputUtil.ok(budgetAppropriationService.queryPaging(query));
    }


}
