package com.elitesland.tw.tw5.server.prd.budget.convert;

import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyDocInfoConvertor;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetOccupyDO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Mapper(uses = PmsBudgetOccupyDocInfoConvertor.class)
public interface PmsBudgetOccupyConvert { // extends BaseConvertMapper<PmsBudgetOccupyVO, PmsBudgetOccupyDO>

    PmsBudgetOccupyConvert INSTANCE = Mappers.getMapper(PmsBudgetOccupyConvert.class);

    @Mapping(target = "docInfo", source = "docInfo", qualifiedByName = "toJsonString")
    PmsBudgetOccupyDO toDo(PmsBudgetOccupyPayload payload);

    @Mapping(target = "docInfo", source = "docInfo", qualifiedByName = "jsonStringToObject")
    PmsBudgetOccupyVO toVo(PmsBudgetOccupyDO ado);

    PmsBudgetOccupyPayload toPayload(PmsBudgetOccupyVO vo);
}
