package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 预算占用管理
 *
 * @author ben
 * @date 2023-12-05
 */
@Entity
@Table(name = "pms_budget_occupy", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_occupy", comment = "预算占用管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetOccupyDO extends BaseModel implements Serializable {
    /** 单据id */
    @Comment("单据id")
    @Column()
    private Long docId;
    /** 费用类型：当量｜费用 */
    @Comment("费用类型：当量｜费用")
    @Column()
    private String costType;
    /** 来源类型：任务｜报销 */
    @Comment("来源类型：任务｜报销")
    @Column()
    private String docType;
    /** 单据编号 */
    @Comment("单据编号")
    @Column()
    private String docCode;
    /** 单据名称 */
    @Comment("单据名称")
    @Column()
    private String docName;
    /** 预算id */
    @Comment("预算id")
    @Column()
    private Long budgetId;
    /** 归属资源（当量预算|费用预算）id */
    @Comment("归属资源（当量预算|费用预算）id")
    @Column()
    private Long belongToId;
    /** 占用数 */
    @Comment("占用数")
    @Column()
    private BigDecimal occupyAmt;
    /** 已使用数 */
    @Comment("已使用数")
    @Column()
    private BigDecimal usedAmt;
    /** 单据时间 */
    @Comment("单据时间")
    @Column()
    private LocalDateTime docTime;
    /** 业务信息 */
    @Comment("业务信息(JSON字符串)")
    @Column()
    private String docInfo;

    public void copy(PmsBudgetOccupyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
