package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 核算-账户流水记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Entity
@Table(name = "cal_account_turnover", indexes = {
        @Index(name = "source_type_id_index", columnList = "source_type,source_id"),
        @Index(name = "acc_index", columnList = "acc_id")
})
@org.hibernate.annotations.Table(appliesTo = "cal_account_turnover", comment = "核算-账户流水记录管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalAccountTurnoverDO extends BaseModel implements Serializable {
    /**
     * 账户id
     */
    @Comment("账户id")
    @Column(name = "acc_id")
    private Long accId;
    /**
     * 账户名称（冗余）
     */
    @Comment("账户名称（冗余）")
    @Column()
    private String accName;
    /**
     * 核算年度
     */
    @Comment("核算年度")
    @Column()
    private Integer finYear;
    /**
     * 核算期间
     */
    @Comment("核算期间")
    @Column()
    private Integer finPeriod;
    /**
     * 交易期间
     */
    @Comment("交易期间")
    @Column()
    private LocalDate ioDate;
    /**
     * 交易时间
     */
    @Comment("交易时间")
    @Column()
    private LocalDateTime ioTime;
    /**
     * 交易单据类型
     */
    @Comment("交易单据类型")
    @Column(name = "source_type")
    private String sourceType;
    /**
     * 交易单据id
     */
    @Comment("交易单据id")
    @Column(name = "source_id")
    private Long sourceId;
    /**
     * 交易单据名称（冗余）
     */
    @Comment("交易单据名称（冗余）")
    @Column()
    private String sourceName;
    /**
     * 交易当量
     */
    @Comment("交易当量")
    @Column()
    private BigDecimal turnoverQty;
    /**
     * 当量价格
     */
    @Comment("当量价格")
    @Column()
    private BigDecimal eqvaPrice;
    /**
     * 交易金额:交易当量*当量价格or直接传值
     */
    @Comment("交易金额:交易当量*当量价格or直接传值")
    @Column()
    private BigDecimal turnoverAmt;
    /**
     * 交易前当量
     */
    @Comment("交易前当量")
    @Column()
    private BigDecimal beforeQty;
    /**
     * 交易后当量
     */
    @Comment("交易后当量")
    @Column()
    private BigDecimal afterQty;
    /**
     * 交易前金额
     */
    @Comment("交易前金额")
    @Column()
    private BigDecimal beforeAmt;
    /**
     * 交易后金额
     */
    @Comment("交易后金额")
    @Column()
    private BigDecimal afterAmt;

    public void copy(CalAccountTurnoverDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
