package com.elitesland.tw.tw5.server.prd.copartner.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeUserDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeUserDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeUserDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeUserDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.QPerformanceReadmeUserDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeUserDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
@Repository
@RequiredArgsConstructor
public class PerformanceReadmeUserDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PerformanceReadmeUserDetailRepo repo;
    private final QPerformanceReadmeUserDetailDO qdo = QPerformanceReadmeUserDetailDO.performanceReadmeUserDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeUserDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PerformanceReadmeUserDetailVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 配置主键
                qdo.configId,
                // 配置详情主键
                qdo.configDetailId,
                //配置员工详情主键
                qdo.configUserId,
                // 员工主键
                qdo.userId,
                // 合同id
                qdo.contractId,
                // 合同名称
                qdo.contractName,
                // 合同类型
                qdo.contractType,
                // 商机id
                qdo.oppoId,
                // 商机名称
                qdo.oppoName,
                // 业务种类
                qdo.businessType,
                // 签单金额
                qdo.amount,
                // 签单金额（不含税）
                qdo.amountNoTax,
                // 签单销售人员id
                qdo.saleUserId,
                // 工时总人天
                qdo.totalDays,
                // 工时售前人天
                qdo.preSaleDays,
                // 售前支持角色
                qdo.preSaleRole,
                // 工时商务人天
                qdo.businessDays,
                // 商务支持角色
                qdo.businessRole,
                qdo.ratio,
                qdo.amt,
                // 工时交付人天
                qdo.deliDays,
                // 交付支持角色
                qdo.deliRole,
                qdo.oppoStatus,
                qdo.taskName,
                qdo.taskType,
                qdo.incomeBuId,
                qdo.taskRole,
                qdo.taskDetail,
                qdo.taskIncomeDesc,
                qdo.createFlag,
                qdo.projectId,
                qdo.projectName,
                // 拓展字符串1
                qdo.extStr1,
                // 拓展字符串2
                qdo.extStr2,
                // 拓展字符串3
                qdo.extStr3,
                // 拓展字符串4
                qdo.extStr4,
                // 拓展字符串5
                qdo.extStr5,
                // 拓展数字1
                qdo.extNumber1,
                // 拓展数字2
                qdo.extNumber2,
                // 拓展数字3
                qdo.extNumber3,
                // 拓展主键1
                qdo.extKey1,
                // 拓展主键2
                qdo.extKey2,
                // 拓展主键3
                qdo.extKey3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeUserDetailVO> getJpaQueryWhere(PerformanceReadmeUserDetailQuery query) {
        JPAQuery<PerformanceReadmeUserDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PerformanceReadmeUserDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PerformanceReadmeUserDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 配置主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 配置详情主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigDetailId())) {
            list.add(qdo.configDetailId.eq(query.getConfigDetailId()));
        }
        /** 配置员工详情主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigUserId())) {
            list.add(qdo.configUserId.eq(query.getConfigUserId()));
        }
        /** 员工主键 精确 */
        if (!ObjectUtils.isEmpty(query.getUserId())) {
            list.add(qdo.userId.eq(query.getUserId()));
        }
        /** 合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 合同名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getContractName())) {
            list.add(qdo.contractName.like(SqlUtil.toSqlLikeString(query.getContractName())));
        }
        /** 合同类型 精确 */
        if (!ObjectUtils.isEmpty(query.getContractType())) {
            list.add(qdo.contractType.eq(query.getContractType()));
        }
        /** 商机id 精确 */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
            list.add(qdo.oppoId.eq(query.getOppoId()));
        }
        /** 商机名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getOppoName())) {
            list.add(qdo.oppoName.like(SqlUtil.toSqlLikeString(query.getOppoName())));
        }
        /** 业务种类 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessType())) {
            list.add(qdo.businessType.eq(query.getBusinessType()));
        }
        /** 签单金额 精确 */
        if (!ObjectUtils.isEmpty(query.getAmount())) {
            list.add(qdo.amount.eq(query.getAmount()));
        }
        /** 签单金额（不含税） 精确 */
        if (!ObjectUtils.isEmpty(query.getAmountNoTax())) {
            list.add(qdo.amountNoTax.eq(query.getAmountNoTax()));
        }
        /** 签单销售人员id 精确 */
        if (!ObjectUtils.isEmpty(query.getSaleUserId())) {
            list.add(qdo.saleUserId.eq(query.getSaleUserId()));
        }
        /** 工时总人天 精确 */
        if (!ObjectUtils.isEmpty(query.getTotalDays())) {
            list.add(qdo.totalDays.eq(query.getTotalDays()));
        }
        /** 工时售前人天 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleDays())) {
            list.add(qdo.preSaleDays.eq(query.getPreSaleDays()));
        }
        /** 售前支持角色 精确 */
        if (!ObjectUtils.isEmpty(query.getPreSaleRole())) {
            list.add(qdo.preSaleRole.eq(query.getPreSaleRole()));
        }
        /** 工时商务人天 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessDays())) {
            list.add(qdo.businessDays.eq(query.getBusinessDays()));
        }
        /** 商务支持角色 精确 */
        if (!ObjectUtils.isEmpty(query.getBusinessRole())) {
            list.add(qdo.businessRole.eq(query.getBusinessRole()));
        }

        /** 工时交付人天 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliDays())) {
            list.add(qdo.deliDays.eq(query.getDeliDays()));
        }
        /** 交付支持角色 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliRole())) {
            list.add(qdo.deliRole.eq(query.getDeliRole()));
        }
        /** 拓展字符串1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr1())) {
            list.add(qdo.extStr1.eq(query.getExtStr1()));
        }
        /** 拓展字符串2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr2())) {
            list.add(qdo.extStr2.eq(query.getExtStr2()));
        }
        /** 拓展字符串3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr3())) {
            list.add(qdo.extStr3.eq(query.getExtStr3()));
        }
        /** 拓展字符串4 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr4())) {
            list.add(qdo.extStr4.eq(query.getExtStr4()));
        }
        /** 拓展字符串5 精确 */
        if (!ObjectUtils.isEmpty(query.getExtStr5())) {
            list.add(qdo.extStr5.eq(query.getExtStr5()));
        }
        /** 拓展数字1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtNumber1())) {
            list.add(qdo.extNumber1.eq(query.getExtNumber1()));
        }
        /** 拓展数字2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtNumber2())) {
            list.add(qdo.extNumber2.eq(query.getExtNumber2()));
        }
        /** 拓展数字3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtNumber3())) {
            list.add(qdo.extNumber3.eq(query.getExtNumber3()));
        }
        /** 拓展主键1 精确 */
        if (!ObjectUtils.isEmpty(query.getExtKey1())) {
            list.add(qdo.extKey1.eq(query.getExtKey1()));
        }
        /** 拓展主键2 精确 */
        if (!ObjectUtils.isEmpty(query.getExtKey2())) {
            list.add(qdo.extKey2.eq(query.getExtKey2()));
        }
        /** 拓展主键3 精确 */
        if (!ObjectUtils.isEmpty(query.getExtKey3())) {
            list.add(qdo.extKey3.eq(query.getExtKey3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PerformanceReadmeUserDetailVO queryByKey(Long id) {
        JPAQuery<PerformanceReadmeUserDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据配置员工主键查询
     *
     * @param configUserId 主键
     * @return 结果
     */
    public List<PerformanceReadmeUserDetailVO> queryByConfigUserId(Long configUserId) {
        JPAQuery<PerformanceReadmeUserDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.configUserId.eq(configUserId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PerformanceReadmeUserDetailVO> queryListDynamic(PerformanceReadmeUserDetailQuery query) {
        JPAQuery<PerformanceReadmeUserDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PerformanceReadmeUserDetailVO> queryPaging(PerformanceReadmeUserDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PerformanceReadmeUserDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<PerformanceReadmeUserDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PerformanceReadmeUserDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PerformanceReadmeUserDetailDO save(PerformanceReadmeUserDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PerformanceReadmeUserDetailDO> saveAll(List<PerformanceReadmeUserDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PerformanceReadmeUserDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 配置主键
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 配置详情主键
        if (payload.getConfigDetailId() != null) {
            update.set(qdo.configDetailId, payload.getConfigDetailId());
        }
        // 配置员工详情主键
        if (payload.getConfigUserId() != null) {
            update.set(qdo.configUserId, payload.getConfigUserId());
        }
        // 员工主键
        if (payload.getUserId() != null) {
            update.set(qdo.userId, payload.getUserId());
        }
        // 合同id
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 合同名称
        if (payload.getContractName() != null) {
            update.set(qdo.contractName, payload.getContractName());
        }
        // 合同类型
        if (payload.getContractType() != null) {
            update.set(qdo.contractType, payload.getContractType());
        }
        // 商机id
        if (payload.getOppoId() != null) {
            update.set(qdo.oppoId, payload.getOppoId());
        }
        // 商机名称
        if (payload.getOppoName() != null) {
            update.set(qdo.oppoName, payload.getOppoName());
        }
        // 业务种类
        if (payload.getBusinessType() != null) {
            update.set(qdo.businessType, payload.getBusinessType());
        }
        // 签单金额
        if (payload.getAmount() != null) {
            update.set(qdo.amount, payload.getAmount());
        }
        // 签单金额（不含税）
        if (payload.getAmountNoTax() != null) {
            update.set(qdo.amountNoTax, payload.getAmountNoTax());
        }
        // 签单销售人员id
        if (payload.getSaleUserId() != null) {
            update.set(qdo.saleUserId, payload.getSaleUserId());
        }
        // 工时总人天
        if (payload.getTotalDays() != null) {
            update.set(qdo.totalDays, payload.getTotalDays());
        }
        // 工时售前人天
        if (payload.getPreSaleDays() != null) {
            update.set(qdo.preSaleDays, payload.getPreSaleDays());
        }
        // 售前支持角色
        if (payload.getPreSaleRole() != null) {
            update.set(qdo.preSaleRole, payload.getPreSaleRole());
        }
        // 工时商务人天
        if (payload.getBusinessDays() != null) {
            update.set(qdo.businessDays, payload.getBusinessDays());
        }
        // 商务支持角色
        if (payload.getBusinessRole() != null) {
            update.set(qdo.businessRole, payload.getBusinessRole());
        }
        // 工时交付人天
        if (payload.getDeliDays() != null) {
            update.set(qdo.deliDays, payload.getDeliDays());
        }
        // 交付支持角色
        if (payload.getDeliRole() != null) {
            update.set(qdo.deliRole, payload.getDeliRole());
        }
        // 分配比例
        if (payload.getRatio() != null) {
            update.set(qdo.ratio, payload.getRatio());
        }
        // 分配金额
        if (payload.getAmt() != null) {
            update.set(qdo.amt, payload.getAmt());
        }
        // 创建类型
        if (payload.getCreateFlag() != null) {
            update.set(qdo.createFlag, payload.getCreateFlag());
        }
        // 项目id
        if (payload.getProjectId() != null) {
            update.set(qdo.projectId, payload.getProjectId());
        }
        // 项目名称
        if (payload.getProjectName() != null) {
            update.set(qdo.projectName, payload.getProjectName());
        }
        // 拓展字符串1
        if (payload.getExtStr1() != null) {
            update.set(qdo.extStr1, payload.getExtStr1());
        }
        // 拓展字符串2
        if (payload.getExtStr2() != null) {
            update.set(qdo.extStr2, payload.getExtStr2());
        }
        // 拓展字符串3
        if (payload.getExtStr3() != null) {
            update.set(qdo.extStr3, payload.getExtStr3());
        }
        // 拓展字符串4
        if (payload.getExtStr4() != null) {
            update.set(qdo.extStr4, payload.getExtStr4());
        }
        // 拓展字符串5
        if (payload.getExtStr5() != null) {
            update.set(qdo.extStr5, payload.getExtStr5());
        }
        // 拓展数字1
        if (payload.getExtNumber1() != null) {
            update.set(qdo.extNumber1, payload.getExtNumber1());
        }
        // 拓展数字2
        if (payload.getExtNumber2() != null) {
            update.set(qdo.extNumber2, payload.getExtNumber2());
        }
        // 拓展数字3
        if (payload.getExtNumber3() != null) {
            update.set(qdo.extNumber3, payload.getExtNumber3());
        }
        // 拓展主键1
        if (payload.getExtKey1() != null) {
            update.set(qdo.extKey1, payload.getExtKey1());
        }
        // 拓展主键2
        if (payload.getExtKey2() != null) {
            update.set(qdo.extKey2, payload.getExtKey2());
        }
        // 拓展主键3
        if (payload.getExtKey3() != null) {
            update.set(qdo.extKey3, payload.getExtKey3());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 配置主键
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 配置详情主键
            if (nullFields.contains("configDetailId")) {
                update.setNull(qdo.configDetailId);
            }
            // 员工主键
            if (nullFields.contains("userId")) {
                update.setNull(qdo.userId);
            }
            // 合同id
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 合同名称
            if (nullFields.contains("contractName")) {
                update.setNull(qdo.contractName);
            }
            // 合同类型
            if (nullFields.contains("contractType")) {
                update.setNull(qdo.contractType);
            }
            // 商机id
            if (nullFields.contains("oppoId")) {
                update.setNull(qdo.oppoId);
            }
            // 商机名称
            if (nullFields.contains("oppoName")) {
                update.setNull(qdo.oppoName);
            }
            // 业务种类
            if (nullFields.contains("businessType")) {
                update.setNull(qdo.businessType);
            }
            // 签单金额
            if (nullFields.contains("amount")) {
                update.setNull(qdo.amount);
            }
            // 签单金额（不含税）
            if (nullFields.contains("amountNoTax")) {
                update.setNull(qdo.amountNoTax);
            }
            // 签单销售人员id
            if (nullFields.contains("saleUserId")) {
                update.setNull(qdo.saleUserId);
            }
            // 工时总人天
            if (nullFields.contains("totalDays")) {
                update.setNull(qdo.totalDays);
            }
            // 工时售前人天
            if (nullFields.contains("preSaleDays")) {
                update.setNull(qdo.preSaleDays);
            }
            // 售前支持角色
            if (nullFields.contains("preSaleRole")) {
                update.setNull(qdo.preSaleRole);
            }
            // 工时商务人天
            if (nullFields.contains("businessDays")) {
                update.setNull(qdo.businessDays);
            }
            // 商务支持角色
            if (nullFields.contains("businessRole")) {
                update.setNull(qdo.businessRole);
            }
            // 工时交付人天
            if (nullFields.contains("deliDays")) {
                update.setNull(qdo.deliDays);
            }
            // 交付支持角色
            if (nullFields.contains("deliRole")) {
                update.setNull(qdo.deliRole);
            }
            // 拓展字符串1
            if (nullFields.contains("extStr1")) {
                update.setNull(qdo.extStr1);
            }
            // 拓展字符串2
            if (nullFields.contains("extStr2")) {
                update.setNull(qdo.extStr2);
            }
            // 拓展字符串3
            if (nullFields.contains("extStr3")) {
                update.setNull(qdo.extStr3);
            }
            // 拓展字符串4
            if (nullFields.contains("extStr4")) {
                update.setNull(qdo.extStr4);
            }
            // 拓展字符串5
            if (nullFields.contains("extStr5")) {
                update.setNull(qdo.extStr5);
            }
            // 拓展数字1
            if (nullFields.contains("extNumber1")) {
                update.setNull(qdo.extNumber1);
            }
            // 拓展数字2
            if (nullFields.contains("extNumber2")) {
                update.setNull(qdo.extNumber2);
            }
            // 拓展数字3
            if (nullFields.contains("extNumber3")) {
                update.setNull(qdo.extNumber3);
            }
            // 拓展主键1
            if (nullFields.contains("extKey1")) {
                update.setNull(qdo.extKey1);
            }
            // 拓展主键2
            if (nullFields.contains("extKey2")) {
                update.setNull(qdo.extKey2);
            }
            // 拓展主键3
            if (nullFields.contains("extKey3")) {
                update.setNull(qdo.extKey3);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据配置员工id逻辑删除
     *
     * @param configUserId 配置员工主键
     * @return 删除的行数
     */
    public long deleteSoftByConfigUserId(Long configUserId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.configUserId.eq(configUserId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

