package com.elitesland.tw.tw5.server.prd.crm.constant;

import lombok.Getter;

/**
 * 客户经营 类型
 *
 * @author duwh
 * @date 2022/11/17
 */
public enum CustomerOperationTypeEnum {

    /**
     * 企业
     */
    ENTERPRISE("enterprise", "企业"),
    /**
     * 组织协会
     */
    ORG_ASSOCIATION("orgAssociation", "组织及协会"),
    /**
     * 政府机构
     */
    GOVERNMENT("government", "政府机构"),
    /**
     * 生态合作伙伴
     */
    ECO_PARTNER("ecoPartner", "生态伙伴"),
    /**
     * 企业及生态伙伴
     */
    ENTERPRISE_ECO_PARTNER("enterpriseEcoPartner", "企业及生态伙伴"),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    CustomerOperationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
