package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationEnterpriseInfoService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 客户经营-企业基本信息
 *
 * @author duwh
 * @date 2022-12-02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/crmCustomerOperationEnterpriseInfo")
@Slf4j
public class CrmCustomerOperationEnterpriseInfoController {

    private final CrmCustomerOperationEnterpriseInfoService crmCustomerOperationEnterpriseInfoService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody CrmCustomerOperationEnterpriseInfoPayload payload) {
        if (null == payload.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", payload);
        }
        return TwOutputUtil.ok(crmCustomerOperationEnterpriseInfoService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody CrmCustomerOperationEnterpriseInfoPayload payload) {
        return TwOutputUtil.ok(crmCustomerOperationEnterpriseInfoService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(crmCustomerOperationEnterpriseInfoService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(CrmCustomerOperationEnterpriseInfoQuery query) {
        if (null == query.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", null);
        }
        return TwOutputUtil.ok(crmCustomerOperationEnterpriseInfoService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(CrmCustomerOperationEnterpriseInfoQuery query) {
        if (null == query.getOperId()) {
            return TwOutputUtil.error("999", "operId参数缺失", null);
        }
        return TwOutputUtil.ok(crmCustomerOperationEnterpriseInfoService.queryList(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        crmCustomerOperationEnterpriseInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
