package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serial;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Entity
@Table(name = "crm_customer_operation", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation", comment = "客户经营")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationDO extends BaseModel {

    @Serial
    private static final long serialVersionUID = 3328010403493353951L;

    @Comment("客户表主键")
    @Column()
    private Long customerId;


//    @Comment("业务伙伴主键")
//    @Column()
//    private Long partnerId;

    @Comment("客户经营编号")
    @Column()
    private String custNo;

    @Comment("类型 udc[crm:cust_oper:type]")
    @Column()
    private String custType;

    @Comment("客户经营状态(激活，暂挂)")
    @Column()
    private String custOperStatus;

    @Comment("第三方公司主键：天眼查id or 启信宝id")
    @Column()
    private String threeId;

    @Comment("第三方公司类型：天眼查:TYC or 启信宝:QXB")
    @Column()
    private String threeType;

    @FieldUpdateLog(fieldName = "名称")
    @FieldCreateLog(fieldName = "名称")
    @Comment("名称")
    @Column()
    private String custName;

    @FieldUpdateLog(fieldName = "公司性质", selectionKey = "crm:company_nature")
    @FieldCreateLog(fieldName = "公司性质", selectionKey = "crm:company_nature")
    @Comment("公司性质 udc[crm:company_nature]")
    @Column()
    private String custNature;

    @FieldUpdateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    @FieldCreateLog(fieldName = "行业", selectionKey = "crm:leads_customer_industry")
    @Comment("行业 udc[crm:leads_customer_industry]")
    @Column()
    private String custIndustry;

    @Comment("母公司主键")
    @Column()
    private Long parentId;

    @FieldUpdateLog(fieldName = "母公司")
    @FieldCreateLog(fieldName = "母公司")
    @Comment("母公司名称")
    @Column()
    private String parentCompany;

    @FieldUpdateLog(fieldName = "网址")
    @FieldCreateLog(fieldName = "网址")
    @Comment("网址")
    @Column()
    private String website;

    @FieldUpdateLog(fieldName = "座机")
    @FieldCreateLog(fieldName = "座机")
    @Comment("座机")
    @Column()
    private String landline;

    @FieldUpdateLog(fieldName = "邮箱")
    @FieldCreateLog(fieldName = "邮箱")
    @Comment("邮箱")
    @Column()
    private String email;

    @Comment("省")
    @Column(name = "province")
    private String province;

    @FieldUpdateLog(fieldName = "省")
    @FieldCreateLog(fieldName = "省")
    @Comment("省")
    @Column()
    private String provinceName;

    @Comment("市")
    @Column(name = "city")
    private String city;

    @FieldUpdateLog(fieldName = "市")
    @FieldCreateLog(fieldName = "市")
    @Comment("市")
    @Column()
    private String cityName;

    @Comment("区")
    @Column(name = "district")
    private String district;

    @FieldUpdateLog(fieldName = "区")
    @FieldCreateLog(fieldName = "区")
    @Comment("区")
    @Column()
    private String districtName;

    @FieldUpdateLog(fieldName = "地址")
    @FieldCreateLog(fieldName = "地址")
    @Comment("地址")
    @Column()
    private String custAddress;

    @FieldUpdateLog(fieldName = "客户级别", selectionKey = "crm:cust_oper:cust_grade")
    @FieldCreateLog(fieldName = "客户级别", selectionKey = "crm:cust_oper:cust_grade")
    @Comment("客户级别 udc[crm:cust_oper:cust_grade]")
    @Column()
    private String custGrade;

    @FieldUpdateLog(fieldName = "销售规模")
    @FieldCreateLog(fieldName = "销售规模")
    @Comment("销售规模")
    @Column()
    private BigDecimal saleScale;

    @FieldUpdateLog(fieldName = "行业地位", selectionKey = "crm:cust_oper:cust_industry")
    @FieldCreateLog(fieldName = "行业地位", selectionKey = "crm:cust_oper:cust_industry")
    @Comment("行业地位 udc[crm:cust_oper:cust_industry]")
    @Column()
    private String industryStand;

    @FieldUpdateLog(fieldName = "数字化投入力度", selectionKey = "crm:cust_oper:digital")
    @FieldCreateLog(fieldName = "数字化投入力度", selectionKey = "crm:cust_oper:digital")
    @Comment("数字化投入力度 udc[crm:cust_oper:digital]")
    @Column()
    private String digitalInvestment;

    @FieldUpdateLog(fieldName = "与公司紧密度", selectionKey = "crm:cust_oper:tightness")
    @FieldCreateLog(fieldName = "与公司紧密度", selectionKey = "crm:cust_oper:tightness")
    @Comment("与公司紧密度 udc[crm:cust_oper:tightness]")
    @Column()
    private String companyTightness;

    @FieldUpdateLog(fieldName = "历史合作产出（万元）")
    @FieldCreateLog(fieldName = "历史合作产出（万元）")
    @Comment("历史合作产出（万元）")
    @Column()
    private BigDecimal historyCooOutput;

    @FieldUpdateLog(fieldName = "销售经营部门", selectionKey = "BU")
    @FieldCreateLog(fieldName = "销售经营部门", selectionKey = "BU")
    @Comment("销售经营部门")
    @Column()
    private Long saleOperBu;

    @FieldUpdateLog(fieldName = "销售经营部负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "销售经营部负责人", selectionKey = "USER")
    @Comment("销售经营部负责人")
    @Column()
    private Long saleOperManagerId;

    @FieldUpdateLog(fieldName = "客户经营部门", selectionKey = "BU")
    @FieldCreateLog(fieldName = "客户经营部门", selectionKey = "BU")
    @Comment("客户经营部门")
    @Column()
    private Long custOperBu;

    @FieldUpdateLog(fieldName = "客户经营部负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "客户经营部负责人", selectionKey = "USER")
    @Comment("客户经营部负责人")
    @Column()
    private Long custOperManagerId;

    @FieldUpdateLog(fieldName = "经营策略", selectionKey = "crm:cust_oper:strategy")
    @FieldCreateLog(fieldName = "经营策略", selectionKey = "crm:cust_oper:strategy")
    @Comment("经营策略 udc[crm:cust_oper:strategy]")
    @Column()
    private String businessStrategy;

    @FieldUpdateLog(fieldName = "主营业务", selectionKey = "crm:cust_oper:main_business")
    @FieldCreateLog(fieldName = "主营业务", selectionKey = "crm:cust_oper:main_business")
    @Comment("主营业务 udc[crm:cust_oper:main_business]")
    @Column()
    private String mainBusiness;

    @Comment("销售覆盖")
    @Column()
    private String saleCover;

    @FieldUpdateLog(fieldName = "合作形式", selectionKey = "crm:cust_oper:coop_type")
    @FieldCreateLog(fieldName = "合作形式", selectionKey = "crm:cust_oper:coop_type")
    @Comment("合作形式 udc[crm:cust_oper:coop_type]")
    @Column()
    private String coopType;

    @Comment("合作等级")
    @Column()
    private String coopLevel;

    @FieldUpdateLog(fieldName = "渠道经营部门", selectionKey = "BU")
    @FieldCreateLog(fieldName = "渠道经营部门", selectionKey = "BU")
    @Comment("渠道经营部门")
    @Column()
    private Long channelBu;

    @FieldUpdateLog(fieldName = "渠道经营负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "渠道经营负责人", selectionKey = "USER")
    @Comment("渠道经营负责人")
    @Column()
    private Long channelUserId;

    @FieldUpdateLog(fieldName = "产品负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "产品负责人", selectionKey = "USER")
    @Comment("产品负责人")
    @Column()
    private Long productUserId;

    @Comment("客户企业 业务简述")
    @Column()
    private String custDescription;

    @Comment("组织及协会简述")
    @Column()
    private String orgAssDescription;

    @Comment("生态伙伴业务简述")
    @Column()
    private String ecoDescription;

    @FieldUpdateLog(fieldName = "服务负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "服务负责人", selectionKey = "USER")
    @Comment("服务负责人")
    @Column()
    private Long serviceUserId;

    @FieldUpdateLog(fieldName = "商务负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "商务负责人", selectionKey = "USER")
    @Comment("商务负责人")
    @Column()
    private Long businessUserId;

    @FieldUpdateLog(fieldName = "关怀负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "关怀负责人", selectionKey = "USER")
    @Comment("关怀负责人")
    @Column()
    private Long careUserId;

    @FieldUpdateLog(fieldName = "运维售后负责人", selectionKey = "USER")
    @FieldCreateLog(fieldName = "运维售后负责人", selectionKey = "USER")
    @Comment("运维售后负责人")
    @Column()
    private Long operationUserId;

    @Comment("经营团队成员")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name = "operId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private java.util.List<CrmCustomerOperationMemberDO> memberList;

    @Comment("经营计划")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name = "operId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private java.util.List<CrmOperationPlanDetailDO> planDetailList;

    @Comment("拓展1")
    @Column()
    private String ext1;

    @Comment("拓展2")
    @Column()
    private String ext2;

    @Comment("拓展3")
    @Column()
    private String ext3;

    @Comment("拓展4")
    @Column()
    private String ext4;

    @Comment("拓展5")
    @Column()
    private String ext5;

    @Comment("提醒时间")
    @Column
    private LocalDateTime noticeTime;

    public CrmCustomerOperationDO() {
    }

    public void copy(CrmCustomerOperationDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
