package com.elitesland.tw.tw5.server.prd.humanresources.ability.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力
 */

@RestController
@RequestMapping("/api/prdCompositeAbility")
@RequiredArgsConstructor
@Api(value = "复合能力", tags = {"复合能力"})
public class PrdCompositeAbilityController {

    private final PrdCompositeAbilityService prdCompositeAbilityService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-复合能力")
    public TwOutputUtil<PrdCompositeAbilityVO> get(@PathVariable Long id) {

        PrdCompositeAbilityVO res = prdCompositeAbilityService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-复合能力")
    public TwOutputUtil<Long> save(@RequestBody PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

        PrdCompositeAbilityVO res = prdCompositeAbilityService.save(prdCompositeAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-复合能力")
    public TwOutputUtil<Long> update(@RequestBody PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

        PrdCompositeAbilityVO res = prdCompositeAbilityService.update(prdCompositeAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-复合能力")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdCompositeAbilityService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @ApiOperation("分页查询-复合能力")
//    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdCompositeAbilityVO>> page(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        PagingVO<PrdCompositeAbilityVO> res = prdCompositeAbilityService.page(prdCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("updateState")
    @ApiOperation("修改-复合能力状态")
    public TwOutputUtil<Long> updateState(@RequestBody PrdCompositeAbilityPayload prdCompositeAbilityPayload) {

        Long res = prdCompositeAbilityService.updateState(prdCompositeAbilityPayload);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/getList")
//    @UdcNameClass
    @ApiOperation("列表查询-复合能力")
    public TwOutputUtil<List<PrdCompositeAbilityVO>> getList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<PrdCompositeAbilityVO> res = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("levelPage")
    @ApiOperation("分页查询-复合能力级别定义")
//    @UdcNameClass
    public TwOutputUtil<PagingVO<PrdCompositeAbilityVO>> levelPage(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        PagingVO<PrdCompositeAbilityVO> res = prdCompositeAbilityService.levelPage(prdCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("levelList")
    @ApiOperation("列表查询-复合能力级别定义")
//    @UdcNameClass
    public TwOutputUtil<List<PrdCompositeAbilityVO>> levelList(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        List<PrdCompositeAbilityVO> res = prdCompositeAbilityService.levelList(prdCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/changeName")
//    @UdcNameClass
    @ApiOperation("修改复合能力名称-复合能力")
    public TwOutputUtil<Boolean> changeName(PrdCompositeAbilityQuery prdCompositeAbilityQuery) {

        Boolean res = prdCompositeAbilityService.changeName(prdCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }

}

