package com.elitesland.tw.tw5.server.prd.humanresources.ability.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-10-23
 * @desc : 复合能力
 */

@Entity
@Table(name = "prd_composite_ability")
@org.hibernate.annotations.Table(appliesTo = "prd_composite_ability", comment = "复合能力")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdCompositeAbilityDO extends BaseModel {


    /**
     * 编号
     */
    @Column(name = "doc_no", columnDefinition = "varchar(255) comment '编号'")
    private String docNo;

    /**
     * 能力名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '能力名称'")
    private String name;

    /**
     * 级别id
     */
    @Column(name = "level_id", columnDefinition = "bigint(20) comment '级别id'")
    private Long levelId;

    /**
     * 级别名称
     */
    @Column(name = "level_name", columnDefinition = "varchar(255) comment '级别名称'")
    private String levelName;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;

    /**
     * 首次审批标志
     */
    @Column(name = "first_audit_flag", columnDefinition = "tinyint(1) comment '首次审批标志'")
    private Boolean firstAuditFlag;

    /**
     * 首次审批审核人
     */
    @Column(name = "first_auditor", columnDefinition = "varchar(255) comment '首次审批审核人'")
    private String firstAuditor;

    /**
     * 首次审批审核人id
     */
    @Column(name = "first_auditor_id", columnDefinition = "bigint(20) comment '首次审批审核人id'")
    private Long firstAuditorId;

    /**
     * 首次审批审核人类型
     */
    @Column(name = "first_auditor_type", columnDefinition = "varchar(255) comment '首次审批审核人类型'")
    private String firstAuditorType;

    /**
     * 首次审批审核人标志
     */
    @Column(name = "first_auditor_up_flag", columnDefinition = "tinyint(1) comment '首次审批审核人标志'")
    private Boolean firstAuditorUpFlag;

    /**
     * 工种类型1
     */
    @Column(name = "job_type1", columnDefinition = "varchar(255) comment '工种类型1'")
    private String jobType1;

    /**
     * 工种类型2
     */
    @Column(name = "job_type2", columnDefinition = "varchar(255) comment '工种类型2'")
    private String jobType2;

    /**
     * 跨级别晋升标志
     */
    @Column(name = "cross_level_flag", columnDefinition = "tinyint(1) comment '跨级别晋升标志'")
    private Boolean crossLevelFlag;

    /**
     * 当量系数
     */
    @Column(name = "dl_ratio", columnDefinition = "decimal(18,4) comment '当量系数'")
    private BigDecimal dlRatio;

    /**
     * 获得方式
     */
    @Column(name = "obtain_type", columnDefinition = "varchar(255) comment '获得方式'")
    private String obtainType;

    /**
     * 能力获取审核人
     */
    @Column(name = "auditor", columnDefinition = "varchar(255) comment '能力获取审核人'")
    private String auditor;

    /**
     * 能力获取审核人id
     */
    @Column(name = "auditor_id", columnDefinition = "bigint(20) comment '能力获取审核人id'")
    private Long auditorId;

    /**
     * 能力获取审核人类型
     */
    @Column(name = "auditor_type", columnDefinition = "varchar(255) comment '能力获取审核人类型'")
    private String auditorType;

    /**
     * 能力以上标志
     */
    @Column(name = "ability_up_flag", columnDefinition = "tinyint(1) comment '能力以上标志'")
    private Boolean abilityUpFlag;

    /**
     * 能力描述
     */
    @Column(name = "ability_desc", columnDefinition = "varchar(255) comment '能力描述'")
    private String abilityDesc;


}

