package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRangeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRangeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核范围
 */

@RestController
@RequestMapping("/api/prdPerformanceExamRange")
@RequiredArgsConstructor
@Api(value = "绩效考核范围", tags = {"绩效考核范围"})
public class PrdPerformanceExamRangeController{
    
    private final PrdPerformanceExamRangeService prdPerformanceExamRangeService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核范围")
    public TwOutputUtil<PrdPerformanceExamRangeVO> get(@PathVariable Long id) {
    
        PrdPerformanceExamRangeVO res = prdPerformanceExamRangeService.get(id);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("save")
    @ApiOperation("新增-绩效考核范围")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        
        PrdPerformanceExamRangeVO res = prdPerformanceExamRangeService.save(prdPerformanceExamRangePayload);
        return TwOutputUtil.ok(res.getId());
        
    }


     @PostMapping("batchSave")
     @ApiOperation("新增-绩效考核范围")
     public TwOutputUtil<Boolean> batchSave(@RequestBody List<PrdPerformanceExamRangePayload> prdPerformanceExamRangePayload) {

         Boolean res = prdPerformanceExamRangeService.batchSave(prdPerformanceExamRangePayload);
         return TwOutputUtil.ok(res);

     }
    
    
    @PostMapping("update")
    @ApiOperation("修改-绩效考核范围")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamRangePayload prdPerformanceExamRangePayload) {
        
        PrdPerformanceExamRangeVO res = prdPerformanceExamRangeService.update(prdPerformanceExamRangePayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核范围")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdPerformanceExamRangeService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核范围")
    public TwOutputUtil<PagingVO<PrdPerformanceExamRangeVO>> page(PrdPerformanceExamRangeQuery prdPerformanceExamRangeQuery) {
        
        PagingVO<PrdPerformanceExamRangeVO> res = prdPerformanceExamRangeService.page(prdPerformanceExamRangeQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

