package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRelatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRelateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRelateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRelateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 可查看考核相关人员
 */

@RestController
@RequestMapping("/api/prdPerformanceExamRelate")
@RequiredArgsConstructor
@Api(value = "可查看考核相关人员", tags = {"可查看考核相关人员"})
public class PrdPerformanceExamRelateController{
    
    private final PrdPerformanceExamRelateService prdPerformanceExamRelateService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-可查看考核相关人员")
    public TwOutputUtil<PrdPerformanceExamRelateVO> get(@PathVariable Long id) {
    
        PrdPerformanceExamRelateVO res = prdPerformanceExamRelateService.get(id);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("save")
    @ApiOperation("新增-可查看考核相关人员")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
        
        PrdPerformanceExamRelateVO res = prdPerformanceExamRelateService.save(prdPerformanceExamRelatePayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-可查看考核相关人员")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
        
        PrdPerformanceExamRelateVO res = prdPerformanceExamRelateService.update(prdPerformanceExamRelatePayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-可查看考核相关人员")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdPerformanceExamRelateService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-可查看考核相关人员")
    public TwOutputUtil<PagingVO<PrdPerformanceExamRelateVO>> page(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        PagingVO<PrdPerformanceExamRelateVO> res = prdPerformanceExamRelateService.page(prdPerformanceExamRelateQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

