package com.elitesland.tw.tw5.server.prd.humanresources.personnel.callback;

import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.EmployeeDepartPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResEntryExitLogPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEntryExitLogService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.EmployeeDepartApplyVO;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.EmployeeDepartApplyDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "RES_DEPART" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class EmployeeDepartWorkFlowCallBackController implements WorkflowCallBack {

    private final EmployeeDepartApplyDAO departApplyDAO;

    private final PrdOrgEmployeeDAO employeeDAO;

    private final SysUserRpcService userRpcService;

    private final UserVacationService userVacationService;

    private final ResEntryExitLogService entryExitLogService;

    private final PrdOrgEmployeeService employeeService;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        EmployeeDepartPayload employeeDepartPayload = new EmployeeDepartPayload();
        employeeDepartPayload.setId(applyId);
        EmployeeDepartApplyVO departApplyVO = departApplyDAO.queryByKey(applyId);
        Long employeeId = departApplyVO.getEmployeeId();
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"激活",流程状态改为未提交
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                //将员工状态变为在职
                employeeDAO.updateResStatus(employeeId, "3");
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                employeeDepartPayload.setProcInstStatus(null);
                employeeDepartPayload.setProcInstId(null);
                employeeDepartPayload.setDeleteFlag(1);
                //将员工状态变为在职
                employeeDAO.updateResStatus(employeeId, "3");
            case INVALID://删除流程并删除离职数据源
                employeeDepartPayload.setProcInstStatus(null);
                employeeDepartPayload.setProcInstId(null);
                employeeDepartPayload.setDeleteFlag(1);
                //将员工状态变为在职
                employeeDAO.updateResStatus(employeeId, "3");
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                employeeDAO.updateResStatus(employeeId, "3");
                break;
            case APPROVED:
                PrdOrgEmployeeVO prdOrgEmployeeVO = employeeDAO.queryByKey(employeeId);
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                employeeDepartPayload.setApprovedTime(LocalDateTime.now());
                employeeDAO.updateResStatus(employeeId, "6");
                //禁用账号
                SysUserBatchSwitchParam sysUserBatchSwitchParam = new SysUserBatchSwitchParam();
                List<Long> userIds = new ArrayList<>();
                userIds.add(prdOrgEmployeeVO.getUserId());
                sysUserBatchSwitchParam.setEnable(false);
                sysUserBatchSwitchParam.setUserIds(userIds);
                userRpcService.batchSwitchUserStatus(sysUserBatchSwitchParam);
                //删除假期
                userVacationService.deleteAllByUserId(prdOrgEmployeeVO.getUserId());
                //保存员工离职日期
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd"); // 定义日期格式化模式
                LocalDate exitDate = LocalDate.parse(departApplyVO.getContractEndDate(), formatter); // 将字符串转换为LocalDate对象
                employeeDAO.updateExitDate(employeeId, exitDate);
                //保存离职记录
                ResEntryExitLogPayload resEntryExitLogPayload = new ResEntryExitLogPayload();
                resEntryExitLogPayload.setEmployeeId(employeeId);
                resEntryExitLogPayload.setEntryExitDate(departApplyVO.getContractEndDate());
                resEntryExitLogPayload.setReasonType1("RES_LEAVE_APPLY");
                resEntryExitLogPayload.setReasonType2("LEAVE");
                resEntryExitLogPayload.setResType(prdOrgEmployeeVO.getExtString6());
                resEntryExitLogPayload.setBookId(prdOrgEmployeeVO.getBookId());
                resEntryExitLogPayload.setOrgId(prdOrgEmployeeVO.getOrgId());
                resEntryExitLogPayload.setBaseCity(prdOrgEmployeeVO.getExtString5());
                resEntryExitLogPayload.setCoopType(prdOrgEmployeeVO.getCooperationMode());
                resEntryExitLogPayload.setJob(prdOrgEmployeeVO.getJobs());
                resEntryExitLogPayload.setLeaveReason(departApplyVO.getHrLeaveDescCode());
                resEntryExitLogPayload.setLeaveReasonDesc(departApplyVO.getHrReason());
                entryExitLogService.save(resEntryExitLogPayload);
                //删除组织关系(不删除还在组织架构中)
                employeeService.deleteOrgRefSoftAll(prdOrgEmployeeVO.getUserId(), exitDate);
                break;
            case APPROVING:
                employeeDepartPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                break;
        }

        departApplyDAO.updateProcData(employeeDepartPayload);
        return WorkflowResult.success(null);
    }
}
