package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;

import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.repo.ResWithdrawApplyDetailRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class ResWithdrawApplyDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final ResWithdrawApplyDetailRepo repo;

    public List<ResWithdrawApplyDetailDO> findAllByApplyId(Long applyId) {
        return repo.findAllByApplyId(applyId);
    }

    public void saveAll(List<ResWithdrawApplyDetailDO> resWithdrawApplyDetailDOList) {
        repo.saveAll(resWithdrawApplyDetailDOList);
    }

    public void deleteAllByApplyId(Long applyId) {
        repo.deleteAllByApplyId(applyId);
    }
}
