package com.elitesland.tw.tw5.server.prd.inv.common;

import io.swagger.annotations.ApiModel;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Optional;


/**
 * 百望发票类型
 *
 * @ Author: ssy
 * @ Date: 2020/5/26
 * @ Description:
 */
@ApiModel("百望发票类型")
public enum InvoiceTypeEnum {

    // 影像-票据列表查询返回的类型
    INV_01("01","增值税专用发票",true),
    INV_02("02","货物运输业增值税专用发票",true),
    INV_03("03","机动车销售统一发票",true),
    INV_04("04","增值税普通发票",true),
    INV_10("10","增值税电子普通发票",true),
    INV_11("11","增值税普通发票(卷式)",true),
    INV_14("14","增值税电子普通发票(通行费)",true),
    INV_15("15","二手车销售统一发票",true),
    INV_1002("1002","火车票",false),
    INV_1003("1003","飞机票",false),
    INV_1004("1004","出租车票",false),
    INV_1005("1005","定额发票",false),
    INV_1006("1006","客运发票",false),
    INV_99("99","其他发票",false),
    //OCR扫描返回的发票类型
    INV_100("100","增值税专用发票",true),
    INV_101("101","增值税普通发票",true),
    INV_102("102","增值税电子普通发票",true),
    INV_200("200","机动车销售统一发票",true),
    INV_201("201","二手车销售统一发票",true),
    INV_300("300","增值税普通发票(卷票)",true),
    INV_301("301","火车票",false),
    INV_302("302","飞机票(电子客票行程单)",false),
    INV_303("303","出租车票",false),
    INV_304("304","客运汽车票",false),
    INV_305("305","定额发票",false),
    INV_306("306","机打发票",false),
    INV_307("307","过路费发票",false),
    INV_308("308","客运船票",false),
    INV_998("998","非发票",false),
    INV_999("999","其他发票",false),
    ;

    @Getter
    private final String code;
    @Getter
    private final String desc;

    @Getter
    private final Boolean needInspect;// false 无需核验；true需要核验

    InvoiceTypeEnum(String code, String desc, Boolean needInspect) {
        this.code = code;
        this.desc = desc;
        this.needInspect = needInspect;
    }

    public static InvoiceTypeEnum  of(String code){
        if(StringUtils.isEmpty(code)){
            return null;
        }
        InvoiceTypeEnum[] values = InvoiceTypeEnum.values();
        Optional<InvoiceTypeEnum> op = Arrays.asList(values).stream().filter(it->it.getCode().equals(code)).findAny();
        if(op.isPresent()){
            return op.get();
        }
        return null;
    }
}
