package com.elitesland.tw.tw5.server.prd.inv.service;

import com.baiwang.bop.request.impl.isp.impl.ImageInvoicesQueryPageRequest;
import com.baiwang.bop.respose.entity.isp.ImageInvoicesQueryPageResponse;
import com.baiwang.open.entity.request.*;
import com.baiwang.open.entity.response.*;
import com.elitesland.tw.tw5.api.prd.inv.service.TwInvoiceSendMsgService;
import com.elitesland.tw.tw5.server.prd.inv.config.TwInvoiceProperties;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @ Author: zoey
 * @ Date: 2023/09/06
 * @ Description:
 */
@Service
@Slf4j
public class TwInvoiceSendMsgServiceImpl extends TwInvoiceBaseService implements TwInvoiceSendMsgService {

    public TwInvoiceSendMsgServiceImpl(TwInvoiceProperties invoiceProperties) {
        super(invoiceProperties);
    }

    @Override
    public OutputInvoiceIssueResponse outputInvoice(OutputInvoiceIssueRequest request) {
        String token = getToken();//获取token
        OutputInvoiceIssueResponse response = BAIWANG_CLIENT_NEW.outputInvoice().issue(request, token);
        log.info("[百望-INVOICE-SERVICE] flowSingleImport: FlowSingleImportRequestNew = {}", request);
        log.info("[百望-INVOICE-SERVICE] flowSingleImport: FlowSingleImportResponse = {}", response);
        return response;
    }

    @Override
    public OutputTransactionUploadResponse flowSingleImport(OutputTransactionUploadRequest request) {
        String token = getToken();//获取token
        OutputTransactionUploadResponse response = BAIWANG_CLIENT_NEW.outputTransaction().upload(request, token);
        log.info("[百望-INVOICE-SERVICE] flowSingleImport: FlowSingleImportRequestNew = {}", request);
        log.info("[百望-INVOICE-SERVICE] flowSingleImport: FlowSingleImportResponse = {}", response);
        return response;
    }

    @Override
    public OutputTransactionDeleteResponse flowSingleDelete(OutputTransactionDeleteRequest request) {
        String token = getToken();//获取token
        OutputTransactionDeleteResponse response = BAIWANG_CLIENT_NEW.outputTransaction().delete(request, token);
        log.info("[百望-INVOICE-SERVICE] flowSingleDelete: FlowSingleDeleteRequestNew = {}", request);
        log.info("[百望-I NVOICE-SERVICE] flowSingleDelete: FlowSingleDeleteResponse = {}", response);
        return response;
    }

    @Override
    public OutputTransactionQueryResponse flowSingleQuery(OutputTransactionQueryRequest request) {
        String token = getToken();//获取token
        OutputTransactionQueryResponse response = BAIWANG_CLIENT_NEW.outputTransaction().query(request, token);
        log.info("[百望-INVOICE-SERVICE] flowSingleQuery: FlowSingleQueryRequestNew = {}", request);
        log.info("[百望-INVOICE-SERVICE] flowSingleQuery: FlowSingleQueryResponse = {}", response);
        return response;
    }

    @Override
    public OutputProductcodeQueryResponse invoiceProductCodeQuery(OutputProductcodeQueryRequest request) {
        String token = getToken();//获取token
        request.setTaxNo(invoiceProperties.getSellerTaxNo());//固定用一个税号去查询
        OutputProductcodeQueryResponse response = BAIWANG_CLIENT_NEW.outputProductcode().query(request, token);
        log.info("[百望-INVOICE-SERVICE] invoiceProductCodeQuery: OutputProductcodeQueryRequest = {}", request);
        log.info("[百望-INVOICE-SERVICE] invoiceProductCodeQuery: OutputProductcodeQueryRequest = {}", response);
        return response;
    }

    @Override
    public OutputEinvoiceQueryResponse invoiceQuery(OutputEinvoiceQueryRequest request) {
        String token = getToken();//获取token
        OutputEinvoiceQueryResponse response = BAIWANG_CLIENT_NEW.outputEinvoice().query(request, token);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryRequest = {}", request);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryResponse = {}", response);
        return response;
    }

    @Override
    public ImageInvoicesQueryPageResponse imageInvoicesQueryOld(ImageInvoicesQueryPageRequest request) {
        String token = getToken();//获取token
        ImageInvoicesQueryPageResponse response = BAIWANG_CLIENT.execute(request, token, ImageInvoicesQueryPageResponse.class);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryRequest = {}", request);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryResponse = {}", response);
        return response;
    }

    @Override
    public ImageInvoicesQueryResponse imageInvoicesQuery(ImageInvoicesQueryRequest request) {
        String token = getToken();//获取token
        ImageInvoicesQueryResponse response = BAIWANG_CLIENT_NEW.imageInvoices().query(request, token);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryRequest = {}", request);
        log.info("[百望-INVOICE-SERVICE] InvoiceQuery: InvoiceQueryResponse = {}", response);
        return response;
    }

}
