package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 工时-资源活动
 *
 * @author duh
 * @date 2022-12-21
 */
@Entity
@Table(name = "t_res_activity", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_res_activity", comment = "工时-资源活动")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ResActivityDO extends BaseModel {
    /**
     * 4.0活动主键
     */
    @Comment("4.0活动主键")
    @Column()
    private Long activityIdV4;
    /**
     * 活动编号
     */
    @Comment("活动编号")
    @Column()
    private String actNo;
    /**
     * 活动名称
     */
    @Comment("活动名称")
    @Column()
    private String actName;
    /**
     * 活动状态
     */
    @Comment("活动状态")
    @Column()
    private String actStatus;
    /**
     * 活动资源id
     */
    @Comment("活动资源id")
    @Column()
    private Long actResId;
    /**
     * 项目活动
     */
    @Comment("项目活动")
    @Column()
    private String projAct;
    /**
     * 预计开始日期
     */
    @Comment("预计开始日期")
    @Column()
    private LocalDate planStartDate;
    /**
     * 预计结束日期
     */
    @Comment("预计结束日期")
    @Column()
    private LocalDate planEndDate;
    /**
     * 实际开始日期
     */
    @Comment("实际开始日期")
    @Column()
    private LocalDate actualStartDate;
    /**
     * 活动当量
     */
    @Comment("活动当量")
    @Column()
    private BigDecimal eqvaQty;
    /**
     * 已结算当量
     */
    @Comment("已结算当量")
    @Column()
    private BigDecimal settledEqva;
    /**
     * 是否里程碑
     */
    @Comment("是否里程碑")
    @Column()
    private Integer milestoneFlag;
    /**
     * 完工日期
     */
    @Comment("完工日期")
    @Column()
    private LocalDate finishDate;
    /**
     * 完工说明
     */
    @Comment("完工说明")
    @Column()
    private String finishDesc;
    /**
     * 完工百分比
     */
    @Comment("完工百分比")
    @Column()
    private BigDecimal finishRate;
    /**
     * 要求文档清单
     */
    @Comment("要求文档清单")
    @Column()
    private String requiredDocList;
    /**
     * 任务id 4.0
     */
    @Comment("任务id 4.0")
    @Column()
    private Long taskId;
    /**
     * 项目活动id
     */
    @Comment("项目活动id")
    @Column()
    private Long projActivityId;
    /**
     * 资源活动父id
     */
    @Comment("资源活动父id")
    @Column()
    private Long resActivityPid;
    /**
     * 规划当量
     */
    @Comment("规划当量")
    @Column()
    private BigDecimal planEqva;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 拓展4
     */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(ResActivityDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
