package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveConfigService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveConfigVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveConfigConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveConfigDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveConfigDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;

@Service
@RequiredArgsConstructor
@Slf4j
public class RewardLeaveConfigServiceImpl extends BaseServiceImpl implements RewardLeaveConfigService {

    private final RewardLeaveConfigRepo rewardLeaveConfigRepo;
    private final RewardLeaveConfigDAO rewardLeaveConfigDAO;
    private final PmsProjectService pmsProjectService;

    @Override
    public PagingVO<RewardLeaveConfigVO> queryPaging(RewardLeaveConfigQuery query) {
        PagingVO<RewardLeaveConfigVO> pagingVO = rewardLeaveConfigDAO.queryPaging(query);
        List<RewardLeaveConfigVO> rewardLeaveConfigVOList = pagingVO.getRecords();
        for (RewardLeaveConfigVO rewardLeaveConfigVO : rewardLeaveConfigVOList) {
            if (rewardLeaveConfigVO.getProjectId() != null) {
                rewardLeaveConfigVO.setProjectName(pmsProjectService.querySimpleProjectByKey(rewardLeaveConfigVO.getProjectId()).getProjName());
            }
            if (!ObjectUtils.isEmpty(rewardLeaveConfigVO.getJobGradeList())) {
                List<String> jobGradeList = Arrays.asList(rewardLeaveConfigVO.getJobGradeList().split(","));
                rewardLeaveConfigVO.setJobGrades(jobGradeList);
            }
            if (!ObjectUtils.isEmpty(rewardLeaveConfigVO.getJobGrade2List())) {
                List<String> jobGrade2List = Arrays.asList(rewardLeaveConfigVO.getJobGrade2List().split(","));
                rewardLeaveConfigVO.setJobGrades2(jobGrade2List);
            }
        }
        pagingVO.setRecords(rewardLeaveConfigVOList);
        return pagingVO;
    }

    @Override
    public List<RewardLeaveConfigVO> queryListDynamic(RewardLeaveConfigQuery query) {
        return rewardLeaveConfigDAO.queryListDynamic(query);
    }

    @Override
    public RewardLeaveConfigVO queryByKey(Long key) {
        RewardLeaveConfigDO entity = rewardLeaveConfigRepo.findById(key).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveConfigVO vo = RewardLeaveConfigConvert.INSTANCE.toVo(entity);
        if (ObjectUtils.isEmpty(entity.getJobGradeList())) {
            List<String> jobGradeList = Arrays.asList(entity.getJobGradeList().split(","));
            vo.setJobGrades(jobGradeList);
        }
        if (!ObjectUtils.isEmpty(entity.getJobGrade2List())) {
            List<String> jobGrade2List = Arrays.asList(entity.getJobGrade2List().split(","));
            vo.setJobGrades2(jobGrade2List);
        }
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveConfigVO insert(RewardLeaveConfigPayload payload) {
        RewardLeaveConfigDO entityDo = RewardLeaveConfigConvert.INSTANCE.toDo(payload);
        if (!ObjectUtils.isEmpty(payload.getJobGrades())) {
            String str = String.join(",", payload.getJobGrades());
            entityDo.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty(payload.getJobGrades2())) {
            String str = String.join(",", payload.getJobGrades2());
            entityDo.setJobGrade2List(str);
        }
        return RewardLeaveConfigConvert.INSTANCE.toVo(rewardLeaveConfigRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public RewardLeaveConfigVO update(RewardLeaveConfigPayload payload) {
        RewardLeaveConfigDO entity = rewardLeaveConfigRepo.findById(payload.getId()).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        RewardLeaveConfigDO entityDo = RewardLeaveConfigConvert.INSTANCE.toDo(payload);
        if (!ObjectUtils.isEmpty(payload.getJobGrades())) {
            String str = String.join(",", payload.getJobGrades());
            entityDo.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty(payload.getJobGrades2())) {
            String str = String.join(",", payload.getJobGrades2());
            entityDo.setJobGrade2List(str);
        }
        entity.copy(entityDo);
        return RewardLeaveConfigConvert.INSTANCE.toVo(rewardLeaveConfigRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(RewardLeaveConfigPayload payload) {
        RewardLeaveConfigDO entity = rewardLeaveConfigRepo.findById(payload.getId()).orElseGet(RewardLeaveConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        if (!ObjectUtils.isEmpty(payload.getJobGrades())) {
            String str = String.join(",", payload.getJobGrades());
            payload.setJobGradeList(str);
        }
        if (!ObjectUtils.isEmpty(payload.getJobGrades2())) {
            String str = String.join(",", payload.getJobGrades2());
            payload.setJobGrade2List(str);
        }
        long result = rewardLeaveConfigDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            rewardLeaveConfigDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<RewardLeaveConfigVO> queryBuConfig(RewardLeaveConfigQuery query) {
        return rewardLeaveConfigDAO.queryBuConfig(query);
    }

}

