package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceOtherPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceOtherQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceOtherService;
import com.elitesland.tw.tw5.api.prd.my.vo.ResAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceOtherVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceOtherConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceOtherDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceOtherDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceOtherRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class TAttendanceOtherServiceImpl extends BaseServiceImpl implements TAttendanceOtherService {

    private final TAttendanceOtherRepo tAttendanceOtherRepo;
    private final TAttendanceOtherDAO tAttendanceOtherDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;

    @Value("${tw4.attendance.other}")
    private String attendanceOtherTo5Url;

    @Override
    public PagingVO<TAttendanceOtherVO> queryPaging(TAttendanceOtherQuery query) {
        return tAttendanceOtherDAO.queryPaging(query);
    }

    @Override
    public List<TAttendanceOtherVO> queryListDynamic(TAttendanceOtherQuery query) {
        return tAttendanceOtherDAO.queryListDynamic(query);
    }

    @Override
    public TAttendanceOtherVO queryByKey(Long key) {
        TAttendanceOtherDO entity = tAttendanceOtherRepo.findById(key).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceOtherVO vo = TAttendanceOtherConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceOtherVO insert(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entityDo = TAttendanceOtherConvert.INSTANCE.toDo(payload);
        return TAttendanceOtherConvert.INSTANCE.toVo(tAttendanceOtherRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceOtherVO update(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entity = tAttendanceOtherRepo.findById(payload.getId()).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceOtherDO entityDo = TAttendanceOtherConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceOtherConvert.INSTANCE.toVo(tAttendanceOtherRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TAttendanceOtherPayload payload) {
        TAttendanceOtherDO entity = tAttendanceOtherRepo.findById(payload.getId()).orElseGet(TAttendanceOtherDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tAttendanceOtherDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tAttendanceOtherDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<ResAttendanceOtherVO> getAttendanceResOther(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        return tAttendanceOtherDAO.getAttendanceResOther(resId, attendanceDateStart, attendanceDateEnd);
    }

    @Override
    public void attendanceOtherTo5(String param) {
        String syncType = "attendanceOtherTo5";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("syncVacationApply localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        //同步到5.0
        XxlJobLogger.log("syncVacationApplyDetail syncTime：" + asyncTimeLong);
        String result = httpUtil.sendSyncGet(attendanceOtherTo5Url, reqMap);
        Map<String, Object> data = (Map) JSONObject.parse(result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> attendanceOtherData = (List<Map<String, Object>>) datum;
                //用户请假申请数据构建
                List<TAttendanceOtherDO> tAttendanceOtherDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4AttendanceOtherIds = attendanceOtherData.stream()
                        .map(attendanceOther -> ((Integer) (attendanceOther.get("id") == null ? 0 : attendanceOther.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<TAttendanceOtherDO> oldTAttendanceOtherDOs = tAttendanceOtherRepo.selectByIdV4List(tw4AttendanceOtherIds);
                //idV4相等的进行更新操作
                for (TAttendanceOtherDO attendanceOtherDO : oldTAttendanceOtherDOs) {
                    Long attendanceOtherIdV4 = attendanceOtherDO.getAttendanceOtherIdV4();
                    for (Map applyData : attendanceOtherData) {
                        Long attendanceOtherIdV4FromV4 = ((Integer) ((null == applyData.get("id") ? 0 : applyData.get("id")))).longValue();
                        if (attendanceOtherIdV4.equals(attendanceOtherIdV4FromV4)) {
                            //有则更新表中记录,并跳出内层循环
                            TAttendanceOtherDO attendanceOtherDO1 = this.translateFromV4(applyData, v4AndV5UserIds);
                            attendanceOtherDO1.setId(attendanceOtherDO.getId());
                            tAttendanceOtherDOList.add(attendanceOtherDO1);
                            break;
                        }
                    }
                }
                tAttendanceOtherRepo.saveAll(tAttendanceOtherDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = attendanceOtherData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = ((Integer) (applyData.get("id") == null ? 0 : applyData.get("id"))).longValue();
                    for (TAttendanceOtherDO attendanceOtherDO : oldTAttendanceOtherDOs) {
                        if (attendanceOtherDO.getAttendanceOtherIdV4().equals(applyId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<TAttendanceOtherDO> newTAttendanceOtherDOs = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    TAttendanceOtherDO attendanceOtherDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceOtherDOs.add(attendanceOtherDO1);
                }
                tAttendanceOtherRepo.saveAll(newTAttendanceOtherDOs);
                syncData = "更新了正常打卡" + attendanceOtherData.size() + "条数据";
            } else {
                syncData = "正常打卡数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【正常打卡信息同步，同步日志：{}】", logDO);
    }


    /**
     * 翻译
     *
     * @param attendanceOtherData         v4的数据
     * @param v4AndV5UserIds    v4与v5对应的userId
     * @return
     */
    private TAttendanceOtherDO translateFromV4(Map attendanceOtherData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceOtherDO attendanceOtherDO = BeanUtil.mapToBean(TAttendanceOtherDO.class, attendanceOtherData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceOtherData.get("id")) {
            attendanceOtherDO.setAttendanceOtherIdV4(((Integer) attendanceOtherData.get("id")).longValue());
        }
        if (null != attendanceOtherData.get("attendanceResId")) {
            Long attendanceResId = ((Integer) attendanceOtherData.get("attendanceResId")).longValue();
            attendanceOtherDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceOtherDO;
    }

}

