package com.elitesland.tw.tw5.server.prd.partner.business.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationEnterpriseInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationEnterpriseInfoVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.QBusinessOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationEnterpriseInfoRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务合作伙伴-企业基本信息
 *
 * @author wangly
 * @date 2023-05-18
 */
@Repository
@RequiredArgsConstructor
public class BusinessOperationEnterpriseInfoDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessOperationEnterpriseInfoRepo repo;
    private final QBusinessOperationEnterpriseInfoDO qdo = QBusinessOperationEnterpriseInfoDO.businessOperationEnterpriseInfoDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessOperationEnterpriseInfoVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessOperationEnterpriseInfoVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 地址簿id
                qdo.bookId,
                // 启信宝id
                qdo.idQxb,
                // 企业名称（国家公示)
                qdo.name,
                qdo.formatName,
                // 企业类型
                qdo.econKind,
                // 企业类型代码
                qdo.econKindCode,
                // 注册资本（金额数字+1个空格+万+货币单位）
                qdo.registCapi,
                qdo.currencyUnit,
                qdo.typeNew,
                // 历史名字
                qdo.historyNamesStr,
                // 地址
                qdo.address,
                // 企业注册号
                qdo.regNo,
                // 经营范围
                qdo.scope,
                // 营业开始日期
                qdo.termStart,
                // 营业结束日期
                qdo.termEnd,
                // 所属工商局
                qdo.belongOrg,
                // 企业法定代表人
                qdo.operName,
                // 公司代表人职务
                qdo.title,
                // 成立日期
                qdo.startDate,
                // 注销日期
                qdo.endDate,
                // 核准日期
                qdo.checkDate,
                // 经营状态（旧字段，不建议使用）
                qdo.status,
                qdo.newStatus,
                // 组织机构号
                qdo.orgNo,
                // 统一社会信用代码
                qdo.creditNo,
                // 地区代码
                qdo.districtCode,
                // 实缴资本
                qdo.actualCapi,
                // 企业二级分类
                qdo.categoryNew,
                // 四级行业
                qdo.domain,
                // 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业；
                qdo.tagsStr,
                qdo.revokeReason,
                qdo.revokeDate,
                // 1.16 企业简介
                qdo.enterpriseDesc,
                // 业务伙伴主键 business_partner.id
                qdo.partnerId,
                // 业务伙伴名称
                qdo.partnerName
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessOperationEnterpriseInfoVO> getJpaQueryWhere(BusinessOperationEnterpriseInfoQuery query) {
        JPAQuery<BusinessOperationEnterpriseInfoVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessOperationEnterpriseInfoQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessOperationEnterpriseInfoQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 地址簿id 精确 */
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            list.add(qdo.bookId.eq(query.getBookId()));
        }
        /** 启信宝id 精确 */
        if (!ObjectUtils.isEmpty(query.getIdQxb())) {
            list.add(qdo.idQxb.eq(query.getIdQxb()));
        }
        /** 企业名称（国家公示) 精确 */
        if (!ObjectUtils.isEmpty(query.getName())) {
            list.add(qdo.name.eq(query.getName()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getFormatName())) {
            list.add(qdo.formatName.eq(query.getFormatName()));
        }
        /** 企业类型 精确 */
        if (!ObjectUtils.isEmpty(query.getEconKind())) {
            list.add(qdo.econKind.eq(query.getEconKind()));
        }
        /** 企业类型代码 精确 */
        if (!ObjectUtils.isEmpty(query.getEconKindCode())) {
            list.add(qdo.econKindCode.eq(query.getEconKindCode()));
        }
        /** 注册资本（金额数字+1个空格+万+货币单位） 精确 */
        if (!ObjectUtils.isEmpty(query.getRegistCapi())) {
            list.add(qdo.registCapi.eq(query.getRegistCapi()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getCurrencyUnit())) {
            list.add(qdo.currencyUnit.eq(query.getCurrencyUnit()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getTypeNew())) {
            list.add(qdo.typeNew.eq(query.getTypeNew()));
        }
        /** 历史名字 精确 */
        if (!ObjectUtils.isEmpty(query.getHistoryNamesStr())) {
            list.add(qdo.historyNamesStr.eq(query.getHistoryNamesStr()));
        }
        /** 地址 精确 */
        if (!ObjectUtils.isEmpty(query.getAddress())) {
            list.add(qdo.address.eq(query.getAddress()));
        }
        /** 企业注册号 精确 */
        if (!ObjectUtils.isEmpty(query.getRegNo())) {
            list.add(qdo.regNo.eq(query.getRegNo()));
        }
        /** 经营范围 精确 */
        if (!ObjectUtils.isEmpty(query.getScope())) {
            list.add(qdo.scope.eq(query.getScope()));
        }
        /** 营业开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getTermStart())) {
            list.add(qdo.termStart.eq(query.getTermStart()));
        }
        /** 营业结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getTermEnd())) {
            list.add(qdo.termEnd.eq(query.getTermEnd()));
        }
        /** 所属工商局 精确 */
        if (!ObjectUtils.isEmpty(query.getBelongOrg())) {
            list.add(qdo.belongOrg.eq(query.getBelongOrg()));
        }
        /** 企业法定代表人 精确 */
        if (!ObjectUtils.isEmpty(query.getOperName())) {
            list.add(qdo.operName.eq(query.getOperName()));
        }
        /** 公司代表人职务 精确 */
        if (!ObjectUtils.isEmpty(query.getTitle())) {
            list.add(qdo.title.eq(query.getTitle()));
        }
        /** 成立日期 精确 */
        if (!ObjectUtils.isEmpty(query.getStartDate())) {
            list.add(qdo.startDate.eq(query.getStartDate()));
        }
        /** 注销日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 核准日期 精确 */
        if (!ObjectUtils.isEmpty(query.getCheckDate())) {
            list.add(qdo.checkDate.eq(query.getCheckDate()));
        }
        /** 经营状态（旧字段，不建议使用） 精确 */
        if (!ObjectUtils.isEmpty(query.getStatus())) {
            list.add(qdo.status.eq(query.getStatus()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getNewStatus())) {
            list.add(qdo.newStatus.eq(query.getNewStatus()));
        }
        /** 组织机构号 精确 */
        if (!ObjectUtils.isEmpty(query.getOrgNo())) {
            list.add(qdo.orgNo.eq(query.getOrgNo()));
        }
        /** 统一社会信用代码 精确 */
        if (!ObjectUtils.isEmpty(query.getCreditNo())) {
            list.add(qdo.creditNo.eq(query.getCreditNo()));
        }
        /** 地区代码 精确 */
        if (!ObjectUtils.isEmpty(query.getDistrictCode())) {
            list.add(qdo.districtCode.eq(query.getDistrictCode()));
        }
        /** 实缴资本 精确 */
        if (!ObjectUtils.isEmpty(query.getActualCapi())) {
            list.add(qdo.actualCapi.eq(query.getActualCapi()));
        }
        /** 企业二级分类 精确 */
        if (!ObjectUtils.isEmpty(query.getCategoryNew())) {
            list.add(qdo.categoryNew.eq(query.getCategoryNew()));
        }
        /** 四级行业 精确 */
        if (!ObjectUtils.isEmpty(query.getDomain())) {
            list.add(qdo.domain.eq(query.getDomain()));
        }
        /** 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业； 精确 */
        if (!ObjectUtils.isEmpty(query.getTagsStr())) {
            list.add(qdo.tagsStr.eq(query.getTagsStr()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getRevokeReason())) {
            list.add(qdo.revokeReason.eq(query.getRevokeReason()));
        }
        /**  精确 */
        if (!ObjectUtils.isEmpty(query.getRevokeDate())) {
            list.add(qdo.revokeDate.eq(query.getRevokeDate()));
        }
        /** 1.16 企业简介 精确 */
        if (!ObjectUtils.isEmpty(query.getEnterpriseDesc())) {
            list.add(qdo.enterpriseDesc.eq(query.getEnterpriseDesc()));
        }
        /** 业务伙伴主键 business_partner.id 精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerId())) {
            list.add(qdo.partnerId.eq(query.getPartnerId()));
        }
        /** 业务伙伴名称精确 */
        if (!ObjectUtils.isEmpty(query.getPartnerName())) {
            list.add(qdo.partnerName.eq(query.getPartnerName()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessOperationEnterpriseInfoVO queryByKey(Long id) {
        JPAQuery<BusinessOperationEnterpriseInfoVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessOperationEnterpriseInfoVO> queryListDynamic(BusinessOperationEnterpriseInfoQuery query) {
        JPAQuery<BusinessOperationEnterpriseInfoVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessOperationEnterpriseInfoVO> queryPaging(BusinessOperationEnterpriseInfoQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessOperationEnterpriseInfoVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessOperationEnterpriseInfoVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessOperationEnterpriseInfoVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessOperationEnterpriseInfoDO save(BusinessOperationEnterpriseInfoDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessOperationEnterpriseInfoDO> saveAll(List<BusinessOperationEnterpriseInfoDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessOperationEnterpriseInfoPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 地址簿id
        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        // 启信宝id
        if (payload.getIdQxb() != null) {
            update.set(qdo.idQxb, payload.getIdQxb());
        }
        // 企业名称（国家公示)
        if (payload.getName() != null) {
            update.set(qdo.name, payload.getName());
        }
        if (payload.getFormatName() != null) {
            update.set(qdo.formatName, payload.getFormatName());
        }
        // 企业类型
        if (payload.getEconKind() != null) {
            update.set(qdo.econKind, payload.getEconKind());
        }
        // 企业类型代码
        if (payload.getEconKindCode() != null) {
            update.set(qdo.econKindCode, payload.getEconKindCode());
        }
        // 注册资本（金额数字+1个空格+万+货币单位）
        if (payload.getRegistCapi() != null) {
            update.set(qdo.registCapi, payload.getRegistCapi());
        }
        if (payload.getCurrencyUnit() != null) {
            update.set(qdo.currencyUnit, payload.getCurrencyUnit());
        }
        if (payload.getTypeNew() != null) {
            update.set(qdo.typeNew, payload.getTypeNew());
        }
        // 历史名字
        if (payload.getHistoryNamesStr() != null) {
            update.set(qdo.historyNamesStr, payload.getHistoryNamesStr());
        }
        // 地址
        if (payload.getAddress() != null) {
            update.set(qdo.address, payload.getAddress());
        }
        // 企业注册号
        if (payload.getRegNo() != null) {
            update.set(qdo.regNo, payload.getRegNo());
        }
        // 经营范围
        if (payload.getScope() != null) {
            update.set(qdo.scope, payload.getScope());
        }
        // 营业开始日期
        if (payload.getTermStart() != null) {
            update.set(qdo.termStart, payload.getTermStart());
        }
        // 营业结束日期
        if (payload.getTermEnd() != null) {
            update.set(qdo.termEnd, payload.getTermEnd());
        }
        // 所属工商局
        if (payload.getBelongOrg() != null) {
            update.set(qdo.belongOrg, payload.getBelongOrg());
        }
        // 企业法定代表人
        if (payload.getOperName() != null) {
            update.set(qdo.operName, payload.getOperName());
        }
        // 公司代表人职务
        if (payload.getTitle() != null) {
            update.set(qdo.title, payload.getTitle());
        }
        // 成立日期
        if (payload.getStartDate() != null) {
            update.set(qdo.startDate, payload.getStartDate());
        }
        // 注销日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 核准日期
        if (payload.getCheckDate() != null) {
            update.set(qdo.checkDate, payload.getCheckDate());
        }
        // 经营状态（旧字段，不建议使用）
        if (payload.getStatus() != null) {
            update.set(qdo.status, payload.getStatus());
        }
        if (payload.getNewStatus() != null) {
            update.set(qdo.newStatus, payload.getNewStatus());
        }
        // 组织机构号
        if (payload.getOrgNo() != null) {
            update.set(qdo.orgNo, payload.getOrgNo());
        }
        // 统一社会信用代码
        if (payload.getCreditNo() != null) {
            update.set(qdo.creditNo, payload.getCreditNo());
        }
        // 地区代码
        if (payload.getDistrictCode() != null) {
            update.set(qdo.districtCode, payload.getDistrictCode());
        }
        // 实缴资本
        if (payload.getActualCapi() != null) {
            update.set(qdo.actualCapi, payload.getActualCapi());
        }
        // 企业二级分类
        if (payload.getCategoryNew() != null) {
            update.set(qdo.categoryNew, payload.getCategoryNew());
        }
        // 四级行业
        if (payload.getDomain() != null) {
            update.set(qdo.domain, payload.getDomain());
        }
        // 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业；
        if (payload.getTagsStr() != null) {
            update.set(qdo.tagsStr, payload.getTagsStr());
        }
        if (payload.getRevokeReason() != null) {
            update.set(qdo.revokeReason, payload.getRevokeReason());
        }
        if (payload.getRevokeDate() != null) {
            update.set(qdo.revokeDate, payload.getRevokeDate());
        }
        // 1.16 企业简介
        if (payload.getEnterpriseDesc() != null) {
            update.set(qdo.enterpriseDesc, payload.getEnterpriseDesc());
        }
        // 业务伙伴主键 business_partner.id
        if (payload.getPartnerId() != null) {
            update.set(qdo.partnerId, payload.getPartnerId());
        }
        // 业务伙伴名称
        if (payload.getPartnerName() != null) {
            update.set(qdo.partnerName, payload.getPartnerName());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 地址簿id
            if (nullFields.contains("bookId")) {
                update.setNull(qdo.bookId);
            }
            // 启信宝id
            if (nullFields.contains("idQxb")) {
                update.setNull(qdo.idQxb);
            }
            // 企业名称（国家公示)
            if (nullFields.contains("name")) {
                update.setNull(qdo.name);
            }
            if (nullFields.contains("formatName")) {
                update.setNull(qdo.formatName);
            }
            // 企业类型
            if (nullFields.contains("econKind")) {
                update.setNull(qdo.econKind);
            }
            // 企业类型代码
            if (nullFields.contains("econKindCode")) {
                update.setNull(qdo.econKindCode);
            }
            // 注册资本（金额数字+1个空格+万+货币单位）
            if (nullFields.contains("registCapi")) {
                update.setNull(qdo.registCapi);
            }
            if (nullFields.contains("currencyUnit")) {
                update.setNull(qdo.currencyUnit);
            }
            if (nullFields.contains("typeNew")) {
                update.setNull(qdo.typeNew);
            }
            // 历史名字
            if (nullFields.contains("historyNamesStr")) {
                update.setNull(qdo.historyNamesStr);
            }
            // 地址
            if (nullFields.contains("address")) {
                update.setNull(qdo.address);
            }
            // 企业注册号
            if (nullFields.contains("regNo")) {
                update.setNull(qdo.regNo);
            }
            // 经营范围
            if (nullFields.contains("scope")) {
                update.setNull(qdo.scope);
            }
            // 营业开始日期
            if (nullFields.contains("termStart")) {
                update.setNull(qdo.termStart);
            }
            // 营业结束日期
            if (nullFields.contains("termEnd")) {
                update.setNull(qdo.termEnd);
            }
            // 所属工商局
            if (nullFields.contains("belongOrg")) {
                update.setNull(qdo.belongOrg);
            }
            // 企业法定代表人
            if (nullFields.contains("operName")) {
                update.setNull(qdo.operName);
            }
            // 公司代表人职务
            if (nullFields.contains("title")) {
                update.setNull(qdo.title);
            }
            // 成立日期
            if (nullFields.contains("startDate")) {
                update.setNull(qdo.startDate);
            }
            // 注销日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 核准日期
            if (nullFields.contains("checkDate")) {
                update.setNull(qdo.checkDate);
            }
            // 经营状态（旧字段，不建议使用）
            if (nullFields.contains("status")) {
                update.setNull(qdo.status);
            }
            if (nullFields.contains("newStatus")) {
                update.setNull(qdo.newStatus);
            }
            // 组织机构号
            if (nullFields.contains("orgNo")) {
                update.setNull(qdo.orgNo);
            }
            // 统一社会信用代码
            if (nullFields.contains("creditNo")) {
                update.setNull(qdo.creditNo);
            }
            // 地区代码
            if (nullFields.contains("districtCode")) {
                update.setNull(qdo.districtCode);
            }
            // 实缴资本
            if (nullFields.contains("actualCapi")) {
                update.setNull(qdo.actualCapi);
            }
            // 企业二级分类
            if (nullFields.contains("categoryNew")) {
                update.setNull(qdo.categoryNew);
            }
            // 四级行业
            if (nullFields.contains("domain")) {
                update.setNull(qdo.domain);
            }
            // 1-新三板； 6-主板上市公司； 40-暂停上市； 41-终止上市； 9-香港上市； 17-高新企业；
            if (nullFields.contains("tagsStr")) {
                update.setNull(qdo.tagsStr);
            }
            if (nullFields.contains("revokeReason")) {
                update.setNull(qdo.revokeReason);
            }
            if (nullFields.contains("revokeDate")) {
                update.setNull(qdo.revokeDate);
            }
            // 1.16 企业简介
            if (nullFields.contains("enterpriseDesc")) {
                update.setNull(qdo.enterpriseDesc);
            }
            // 业务伙伴主键 business_partner.id
            if (nullFields.contains("partnerId")) {
                update.setNull(qdo.partnerId);
            }
            // 业务伙伴名称
            if (nullFields.contains("partnerName")) {
                update.setNull(qdo.partnerName);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据partnerId删除
     *
     * @param partnerId 业务伙伴id
     * @return 删除的行数
     */
    public void deleteByPartnerId(Long partnerId){
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.partnerId.eq(partnerId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        update.execute();
    }

}

