package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.BusinessOperationPartnerVO;
import com.elitesland.tw.tw5.server.prd.partner.business.convert.BusinessOperationPartnerConvert;
import com.elitesland.tw.tw5.server.prd.partner.business.dao.BusinessOperationPartnerDAO;
import com.elitesland.tw.tw5.server.prd.partner.business.entity.BusinessOperationPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.business.repo.BusinessOperationPartnerRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-工商股东
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessOperationPartnerServiceImpl extends BaseServiceImpl implements BusinessOperationPartnerService {

    private final BusinessOperationPartnerRepo businessOperationPartnerRepo;
    private final BusinessOperationPartnerDAO businessOperationPartnerDAO;

    @Override
    public PagingVO<BusinessOperationPartnerVO> queryPaging(BusinessOperationPartnerQuery query){
        return businessOperationPartnerDAO.queryPaging(query);
    }

    @Override
    public List<BusinessOperationPartnerVO> queryListDynamic(BusinessOperationPartnerQuery query){
        return businessOperationPartnerDAO.queryListDynamic(query);
    }

    @Override
    public BusinessOperationPartnerVO queryByKey(Long key) {
        BusinessOperationPartnerDO entity = businessOperationPartnerRepo.findById(key).orElseGet(BusinessOperationPartnerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationPartnerVO vo = BusinessOperationPartnerConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationPartnerVO insert(BusinessOperationPartnerPayload payload) {
        BusinessOperationPartnerDO entityDo = BusinessOperationPartnerConvert.INSTANCE.toDo(payload);
        return BusinessOperationPartnerConvert.INSTANCE.toVo(businessOperationPartnerRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessOperationPartnerVO update(BusinessOperationPartnerPayload payload) {
        BusinessOperationPartnerDO entity = businessOperationPartnerRepo.findById(payload.getId()).orElseGet(BusinessOperationPartnerDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessOperationPartnerDO entityDo = BusinessOperationPartnerConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessOperationPartnerConvert.INSTANCE.toVo(businessOperationPartnerRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessOperationPartnerDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public void deleteByPartnerId(Long partnerId) {
        businessOperationPartnerDAO.deleteByPartnerId(partnerId);
    }

}
