package com.elitesland.tw.tw5.server.prd.partner.common.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_book_account", indexes = {
        @Index(name="index_book_id",columnList = "book_id")
})
@org.hibernate.annotations.Table(appliesTo = "com_book_account", comment = "业务伙伴-账户信息")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BookAccountDO extends BaseModel implements Serializable  {
    /** 地址薄id */
    @Comment("地址薄id")
    @Column(name = "book_id")
    private Long bookId;

    /** 账户类型 udc[prd:ab:account_type] */
    @Comment("账户用途 udc[prd:ab:account_usage]")
    @Column()
    @FieldUpdateLog(fieldName = "账户用途", selectionKey = "prd:ab:account_usage")
    @FieldCreateLog(fieldName = "账户用途", selectionKey = "prd:ab:account_usage")
    private String accountUsage;

    /** 账户类型 udc[prd:ab:account_type] */
    @Comment("账户类型 udc[prd:ab:account_type]")
    @Column()
    @FieldUpdateLog(fieldName = "账户类型", selectionKey = "prd:ab:account_type")
    @FieldCreateLog(fieldName = "账户类型", selectionKey = "prd:ab:account_type")
    private String accountType;
    /** 银行 udc[prd:ab:bank_name] */
    @Comment("银行 udc[prd:ab:bank_name]")
    @Column()
    @FieldUpdateLog(fieldName = "银行", selectionKey = "prd:ab:bank_name")
    @FieldCreateLog(fieldName = "银行", selectionKey = "prd:ab:bank_name")
    private String depositBank;
    /** 开户地 */
    @Comment("开户地")
    @Column()
    @FieldCreateLog(fieldName = "开户地")
    @FieldUpdateLog(fieldName = "开户地")
    private String depositCity;
    /** 开户网点 */
    @Comment("开户网点")
    @Column()
    @FieldCreateLog(fieldName = "开户网点")
    @FieldUpdateLog(fieldName = "开户网点")
    private String depositBankOutlet;
    /** 户名 */
    @Comment("户名")
    @Column()
    @FieldCreateLog(fieldName = "户名")
    @FieldUpdateLog(fieldName = "户名")
    private String accountName;
    /** 账户号 */
    @Comment("账户号")
    @Column()
    @FieldCreateLog(fieldName = "账户号")
    @FieldUpdateLog(fieldName = "账户号")
    private String accountNo;
    /** 币种 udc[SYSTEM_BASIC:CURRENCY] */
    @Comment("币种 udc[SYSTEM_BASIC:CURRENCY]")
    @Column()
    @FieldUpdateLog(fieldName = "币种", selectionKey = "SYSTEM_BASIC:CURRENCY")
    @FieldCreateLog(fieldName = "币种", selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currency;
    /** 是否为默认账户  */
    @Comment(value="是否为默认账户",defaultValue = "false")
    @Column()
    @FieldUpdateLog(fieldName = "默认账户", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    @FieldCreateLog(fieldName = "默认账户", selectionKey = "CRM:BUSINESS_PARTNER:SWITCH")
    private Boolean isDefault;

    public void copy(BookAccountDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
