package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessSupplierInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchasePaymentService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.JdeDocType;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessSupplierInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessSupplierInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessSupplierInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessSupplierInfoRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * 业务伙伴-供应商信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessSupplierInfoServiceImpl extends BaseServiceImpl implements BusinessSupplierInfoService {

    private final BusinessSupplierInfoRepo businessSupplierInfoRepo;
    private final BusinessSupplierInfoDAO businessSupplierInfoDAO;
    private final FileUtil fileUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final BookAccountService bookAccountService;


    @Autowired
    @Lazy
    private  BusinessPartnerService businessPartnerService;


    @Override
    public PagingVO<BusinessSupplierInfoVO> queryPaging(BusinessSupplierInfoQuery query) {
        return businessSupplierInfoDAO.queryPaging(query);
    }

    @Override
    public List<BusinessSupplierInfoVO> queryListDynamic(BusinessSupplierInfoQuery query) {
        List<BusinessSupplierInfoVO> businessSupplierInfoVOS = businessSupplierInfoDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessSupplierInfoVOS)) {
            businessSupplierInfoVOS.stream().forEach(vo -> {
                vo.setFileData1(fileUtil.getFileDatas(vo.getFileCode1()));
                vo.setFileData2(fileUtil.getFileDatas(vo.getFileCode2()));
            });
        }

        return businessSupplierInfoVOS;
    }

    @Override
    public BusinessSupplierInfoVO queryByKey(Long key) {
        BusinessSupplierInfoDO entity = businessSupplierInfoRepo.findById(key).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");

        BusinessSupplierInfoVO vo = BusinessSupplierInfoConvert.INSTANCE.toVo(entity);
        vo.setFileData1(fileUtil.getFileDatas(vo.getFileCode1()));
        vo.setFileData2(fileUtil.getFileDatas(vo.getFileCode2()));
        return vo;
    }

    @Override
    public BusinessSupplierInfoVO queryByPartnerId(Long partnerId) {
        BusinessSupplierInfoDO entity = businessSupplierInfoRepo.findByPartnerId(partnerId);
        if (entity == null) {
            throw TwException.error("", "供应商对象不存在");
        }
        BusinessSupplierInfoVO vo = BusinessSupplierInfoConvert.INSTANCE.toVo(entity);
        vo.setFileData1(fileUtil.getFileDatas(vo.getFileCode1()));
        vo.setFileData2(fileUtil.getFileDatas(vo.getFileCode2()));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessSupplierInfoVO insert(BusinessSupplierInfoPayload payload) {
        payload.setSyncJdeFlag(false);
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        return BusinessSupplierInfoConvert.INSTANCE.toVo(businessSupplierInfoRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessSupplierInfoVO update(BusinessSupplierInfoPayload payload) {
        BusinessSupplierInfoDO entity = businessSupplierInfoRepo.findById(payload.getId()).orElseGet(BusinessSupplierInfoDO::new);
        Assert.notNull(entity.getId(), "不存在");

        // 变更日志用
        BusinessSupplierInfoDO entityLog = new BusinessSupplierInfoDO();
        BeanUtils.copyProperties(entity, entityLog);
        BusinessSupplierInfoDO entityDo = BusinessSupplierInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //操作记录
        if (null != payload.getPartnerId()) {
            // 修改NULL值特殊处理
            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
            //获取变更日志
            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
            //  logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "更改账户信息");
        }
        return BusinessSupplierInfoConvert.INSTANCE.toVo(businessSupplierInfoRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessSupplierInfoDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSupplierStatus(Long partnerId, String partnerName, String supplierStatus) {
        // 判断是否有银行账户信息
//        BookAccountQuery bookAccountQuery=new BookAccountQuery();
//        bookAccountQuery.setBookId();
//
//        bookAccountService.count(BookAccountQuery.builder().partnerId(partnerId).build());

        businessSupplierInfoDAO.updateSupplierStatus(partnerId, supplierStatus);
    }
    @Override
    public Boolean activeSupplierCheck(Long bookId) {

        Assert.notNull(bookId, "bookId不能为空");
        // 判断是否有银行账户信息
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        Long count = bookAccountService.count(bookAccountQuery);
        if (count > 0) {
            return true;
        }

        return false;
    }

    @Override
    public Boolean activeSupplierCheckWithChange(Long bookId) {

        Assert.notNull(bookId, "bookId不能为空");

        // 判断是否有银行账户信息
        BookAccountQuery bookAccountQuery = new BookAccountQuery();
        bookAccountQuery.setBookId(bookId);
        Long count = bookAccountService.count(bookAccountQuery);
        if (count > 0) {
            return true;
        }

        // 校验有没有变更流程

        //  客户发票变更流程
        List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryByBookId(bookId);
        if (CollectionUtils.isEmpty(businessPartnerVOS)) {
            return false;
        }

        BusinessPartnerVO businessPartnerVO = businessPartnerVOS.get(0);
        if (StrUtil.isNotBlank(businessPartnerVO.getApplyStatus()) && businessPartnerVO.getApplyStatus().equals(BusinessPartnerStatusEnum.APPROVING.getCode())) {
            return true;
        }

        return false;

    }

    @Override
    public BusinessSupplierInfoVO quertByBookId(Long supplierBookId) {

        BusinessSupplierInfoVO res = businessSupplierInfoDAO.quertByBookId(supplierBookId);
        return res;
    }

}
