package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyGradeSettingPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyGradeSettingQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyGradeSettingService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyGradeSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略等级配置
 *
 * @folder 分级策略-等级配置
 * @author wangly
 * @date 2023-06-16
 */
@Api(tags = "分级策略等级配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyGradeSetting")
@Slf4j
public class BusinessStrategyGradeSettingController {

private final BusinessStrategyGradeSettingService businessStrategyGradeSettingService;

    /**
     * 分级策略等级配置-新增
     *
     * @folder 分级策略-等级配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略等级配置-新增")
    public TwOutputUtil<BusinessStrategyGradeSettingVO> insert(@RequestBody BusinessStrategyGradeSettingPayload payload){
         return TwOutputUtil.ok(businessStrategyGradeSettingService.insert(payload));
    }

    /**
     * 分级策略等级配置-更新
     *
         * @folder 分级策略-等级配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略等级配置-更新")
    public TwOutputUtil<BusinessStrategyGradeSettingVO> update(@RequestBody BusinessStrategyGradeSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyGradeSettingService.update(payload));
    }

    /**
     * 分级策略等级配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-等级配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略等级配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyGradeSettingPayload payload){
        return TwOutputUtil.ok(businessStrategyGradeSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略等级配置-主键查询
     *
     * @folder 分级策略-等级配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略等级配置-主键查询")
    public TwOutputUtil<BusinessStrategyGradeSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyGradeSettingService.queryByKey(key));
    }

    /**
     * 分级策略等级配置-分页
     *
         * @folder 分级策略-等级配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略等级配置-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyGradeSettingVO>> paging(BusinessStrategyGradeSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyGradeSettingService.queryPaging(query));
    }

    /**
     * 分级策略等级配置-查询列表
     *
     * @folder 分级策略-等级配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略等级配置-查询列表")
    public TwOutputUtil<List<BusinessStrategyGradeSettingVO>> queryList(BusinessStrategyGradeSettingQuery query) {
        return TwOutputUtil.ok(businessStrategyGradeSettingService.queryListDynamic(query));
    }

    /**
     * 分级策略等级配置-删除
     *
     * @folder 分级策略-等级配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略等级配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyGradeSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

