package com.elitesland.tw.tw5.server.prd.partner.strategy.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 分级策略模型配置
 *
 * @author wangly
 * @date 2023-06-19
 */
@Entity
@Table(name = "business_strategy_model", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "business_strategy_model", comment = "分级策略模型配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessStrategyModelDO extends BaseModel implements Serializable  {
    /** 模型编号 */
    @Comment("模型编号")
    @Column()
    private String modelNo;
    /** 模型名称 */
    @Comment("模型名称")
    @Column()
    private String modelName;
    /** 模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE] */
    @Comment("模型类型 udc[CRM:BUSINESS_STRATEGY_MODEL:TYPE]")
    @Column()
    private String modelType;
    /** 是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG] */
    @Comment("是否标准模版 udc[CRM:BUSINESS_STRATEGY_MODEL:FLAG]")
    @Column()
    private Boolean standaryFlag;
    /** 开始时间 */
    @Comment("开始时间")
    @Column()
    private LocalDateTime startTime;
    /** 结束时间 */
    @Comment("结束时间")
    @Column()
    private LocalDateTime endTime;
    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE] */
    @Comment("数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:SOURCE]")
    @Column()
    private String source;

    /** 数据来源 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE] */
    @Comment("时间范围 udc[CRM:BUSINESS_STRATEGY_MODEL:DATE]")
    @Column()
    private String dateRange;

    /** R权重 */
    @Comment("R权重")
    @Column()
    private BigDecimal RWeight;

    /** F权重 */
    @Comment("F权重")
    @Column()
    private BigDecimal FWeight;

    /** M权重 */
    @Comment("M权重")
    @Column()
    private BigDecimal MWeight;

    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(BusinessStrategyModelDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
