package com.elitesland.tw.tw5.server.prd.pms.dao;


import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsDistributeRespondDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRespondRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
@Repository
@RequiredArgsConstructor
public class PmsDistributeRespondDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsDistributeRespondRepo repo;
    private final QPmsDistributeRespondDO qdo = QPmsDistributeRespondDO.pmsDistributeRespondDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeRespondVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsDistributeRespondVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 派发ID
                qdo.distId,
                // 派发对象
                qdo.reasonName,
                // 派发人
                qdo.disterResId,
                // 响应状态
                qdo.respStatus,
                // 响应时间
                qdo.respTime,
                // 响应描述
                qdo.respDesc,
                // 是否邀请
                qdo.inviteFlag,
                // 响应资源ID
                qdo.respondentResId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsDistributeRespondVO> getJpaQueryWhere(PmsDistributeRespondQuery query) {
        JPAQuery<PmsDistributeRespondVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsDistributeRespondQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
            .select(qdo.count())
            .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsDistributeRespondQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 派发ID 精确 */
        if (!ObjectUtils.isEmpty(query.getDistId())) {
            list.add(qdo.distId.eq(query.getDistId()));
        }
        if (!ObjectUtils.isEmpty(query.getDistIds())) {
            list.add(qdo.distId.in(query.getDistIds()));
        }
        /** 派发对象 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.eq(query.getReasonName()));
        }
        /** 派发人 精确 */
        if (!ObjectUtils.isEmpty(query.getDisterResId())) {
            list.add(qdo.disterResId.eq(query.getDisterResId()));
        }
        /** 响应状态 精确 */
        if (!ObjectUtils.isEmpty(query.getRespStatus())) {
            list.add(qdo.respStatus.eq(query.getRespStatus()));
        }
        /** 响应时间 精确 */
        if (!ObjectUtils.isEmpty(query.getRespTime())) {
            list.add(qdo.respTime.eq(query.getRespTime()));
        }
        /** 响应描述 精确 */
        if (!ObjectUtils.isEmpty(query.getRespDesc())) {
            list.add(qdo.respDesc.eq(query.getRespDesc()));
        }
        /** 是否邀请 精确 */
        if (!ObjectUtils.isEmpty(query.getInviteFlag())) {
            list.add(qdo.inviteFlag.eq(query.getInviteFlag()));
        }
        /** 响应资源ID 精确 */
        if (!ObjectUtils.isEmpty(query.getRespondentResId())) {
            list.add(qdo.respondentResId.eq(query.getRespondentResId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsDistributeRespondVO queryByKey(Long id) {
        JPAQuery<PmsDistributeRespondVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsDistributeRespondVO> queryListDynamic(PmsDistributeRespondQuery query) {
        JPAQuery<PmsDistributeRespondVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsDistributeRespondVO> queryPaging(PmsDistributeRespondQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PmsDistributeRespondVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsDistributeRespondVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsDistributeRespondVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsDistributeRespondDO save(PmsDistributeRespondDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsDistributeRespondDO> saveAll(List<PmsDistributeRespondDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsDistributeRespondPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 派发ID
        if (payload.getDistId() != null) {
            update.set(qdo.distId, payload.getDistId());
        }
        // 派发对象
        if (payload.getReasonName() != null) {
            update.set(qdo.reasonName, payload.getReasonName());
        }
        // 派发人
        if (payload.getDisterResId() != null) {
            update.set(qdo.disterResId, payload.getDisterResId());
        }
        // 响应状态
        if (payload.getRespStatus() != null) {
            update.set(qdo.respStatus, payload.getRespStatus());
        }
        // 响应时间
        if (payload.getRespTime() != null) {
            update.set(qdo.respTime, payload.getRespTime());
        }
        // 响应描述
        if (payload.getRespDesc() != null) {
            update.set(qdo.respDesc, payload.getRespDesc());
        }
        // 是否邀请
        if (payload.getInviteFlag() != null) {
            update.set(qdo.inviteFlag, payload.getInviteFlag());
        }
        // 响应资源ID
        if (payload.getRespondentResId() != null) {
            update.set(qdo.respondentResId, payload.getRespondentResId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 派发ID
            if (nullFields.contains("distId")) {
                update.setNull(qdo.distId);
            }
            // 派发对象
            if (nullFields.contains("reasonName")) {
                update.setNull(qdo.reasonName);
            }
            // 派发人
            if (nullFields.contains("disterResId")) {
                update.setNull(qdo.disterResId);
            }
            // 响应状态
            if (nullFields.contains("respStatus")) {
                update.setNull(qdo.respStatus);
            }
            // 响应时间
            if (nullFields.contains("respTime")) {
                update.setNull(qdo.respTime);
            }
            // 响应描述
            if (nullFields.contains("respDesc")) {
                update.setNull(qdo.respDesc);
            }
            // 是否邀请
            if (nullFields.contains("inviteFlag")) {
                update.setNull(qdo.inviteFlag);
            }
            // 响应资源ID
            if (nullFields.contains("respondentResId")) {
                update.setNull(qdo.respondentResId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据派发ID删除
     *
     * @param distIds 派发ID
     * @return 删除的行数
     */
    public long deleteByDistIds(List<Long> distIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.distId.in(distIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 批量更新状态
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long updateStatus(List<Long> keys,String respStatus) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.respStatus, respStatus)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

