package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 资源计划角色明细
 *
 * @author xxb
 * @date 2023-08-11
 */
@Entity
@Table(name = "pms_resource_plan_role", indexes = {
        @Index(name = "plan_index", columnList = "plan_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_resource_plan_role", comment = "资源计划角色明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsResourcePlanRoleDO extends BaseModel implements Serializable  {
    /** 关联资源计划ID */
    @Comment("关联资源计划ID")
    @Column(name = "plan_id")
    private Long planId;
    /** 角色 */
    @Comment("角色")
    @Column()
    private String role;
    /** 复合能力级别ID */
    @Comment("复合能力级别ID")
    @Column()
    private Long capasetLevelId;
    /** 资源 */
    @Comment("资源")
    @Column()
    private Long resId;
    /** 资源状态 */
    @Comment("资源状态")
    @Column()
    private String planRoleStatus;
    /** 派发系数 */
    @Comment("派发系数")
    @Column()
    private BigDecimal distributeRate;
    /** 开始日期 */
    @Comment("开始日期")
    @Column()
    private LocalDate startDate;
    /** 结束日期 */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /** 汇总人天 */
    @Comment("汇总人天")
    @Column()
    private BigDecimal totalDays;
    /** 汇总当量 */
    @Comment("汇总当量")
    @Column()
    private BigDecimal totalEqva;
    /** 隐藏标志 */
    @Comment("隐藏标志")
    @Column()
    private Integer hiddenFlag;

    /** 以下是预留字段 */

    /** 推荐资源id */
    @Comment("推荐资源id")
    @Column()
    private Long recommendResId;
    /** 读取状态 */
    @Comment("读取状态")
    @Column()
    private String readStatus;
    /** 预计日期 */
    @Comment("预计日期")
    @Column()
    private LocalDate expectedDate;

    public void copy(PmsResourcePlanRoleDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
