package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementDetailsVO;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseAgreementDetailsService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 采购协议明细
 *
 * @author Echo
 * @date 2023-06-08
 */
@Api(tags = "采购协议明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/purchaseAgreementDetails")
@Slf4j
public class PurchaseAgreementDetailsController {

private final PurchaseAgreementDetailsService purchaseAgreementDetailsService;

    /**
     * 采购协议明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("采购协议明细-新增")
    public TwOutputUtil<PurchaseAgreementDetailsVO> insert(@RequestBody PurchaseAgreementDetailsPayload payload){
         return TwOutputUtil.ok(purchaseAgreementDetailsService.insert(payload));
    }

    /**
     * 采购协议明细-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("采购协议明细-更新")
    public TwOutputUtil<PurchaseAgreementDetailsVO> update(@RequestBody PurchaseAgreementDetailsPayload payload){
        return TwOutputUtil.ok(purchaseAgreementDetailsService.update(payload));
    }

    /**
     * 采购协议明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("采购协议明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PurchaseAgreementDetailsPayload payload){
        return TwOutputUtil.ok(purchaseAgreementDetailsService.updateByKeyDynamic(payload));
    }

    /**
     * 采购协议明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
//    @UdcNameClass
    @ApiOperation("采购协议明细-主键查询")
    public TwOutputUtil<PurchaseAgreementDetailsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(purchaseAgreementDetailsService.queryByKey(key));
    }

    /**
     * 采购协议明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
//    @UdcNameClass
    @ApiOperation("采购协议明细-分页")
    public TwOutputUtil<PagingVO<PurchaseAgreementDetailsVO>> paging(PurchaseAgreementDetailsQuery query) {
        return TwOutputUtil.ok(purchaseAgreementDetailsService.queryPaging(query));
    }

    /**
     * 采购协议明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
//    @UdcNameClass
    @ApiOperation("采购协议明细-查询列表")
    public TwOutputUtil<List<PurchaseAgreementDetailsVO>> queryList(PurchaseAgreementDetailsQuery query) {
        return TwOutputUtil.ok(purchaseAgreementDetailsService.queryListDynamic(query));
    }

    /**
     * 采购协议明细-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("采购协议明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         purchaseAgreementDetailsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

