package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.ResSetRatePayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.ResSetRateQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.ResSetRateService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 人力资源结算费率
 *
 * @author lemon
 * @date 2023-11-02
 */
@Api(tags = "人力资源结算费率")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/resSetRate")
@Slf4j
public class ResSetRateController {

    private final ResSetRateService resSetRateService;

    /**
     * 人力资源结算费率-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("人力资源结算费率-新增")
    public TwOutputUtil<ResSetRateVO> insert(@RequestBody ResSetRatePayload payload){
        return TwOutputUtil.ok(resSetRateService.insert(payload));
    }

    /**
     * 人力资源结算费率-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("人力资源结算费率-更新")
    public TwOutputUtil<ResSetRateVO> update(@RequestBody ResSetRatePayload payload){
        return TwOutputUtil.ok(resSetRateService.update(payload));
    }

    /**
     * 人力资源结算费率-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("人力资源结算费率-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody ResSetRatePayload payload){
        return TwOutputUtil.ok(resSetRateService.updateByKeyDynamic(payload));
    }

    /**
     * 人力资源结算费率-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("人力资源结算费率-主键查询")
    public TwOutputUtil<ResSetRateVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(resSetRateService.queryByKey(key));
    }

    /**
     * 人力资源结算费率-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("人力资源结算费率-分页")
    public TwOutputUtil<PagingVO<ResSetRateVO>> paging(ResSetRateQuery query) {
        return TwOutputUtil.ok(resSetRateService.queryPaging(query));
    }

    /**
     * 人力资源结算费率-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("人力资源结算费率-查询列表")
    public TwOutputUtil<List<ResSetRateVO>> queryList(ResSetRateQuery query) {
        return TwOutputUtil.ok(resSetRateService.queryListDynamic(query));
    }

    /**
     * 人力资源结算费率-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("人力资源结算费率-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        resSetRateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

