package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanSavePayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ContractNodeVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 收款计划
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Api(tags = "收款计划")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/receivablePlan")
@Slf4j
public class ConReceivablePlanController {

    private final ConReceivablePlanService conReceivablePlanService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConReceivablePlanPayload payload) {
        return TwOutputUtil.ok(conReceivablePlanService.insert(payload));
    }

    @PatchMapping("/saveRecvPlans")
    @ApiOperation("保存多条记录")
    public TwOutputUtil saveRecvPlans(@RequestBody ConReceivablePlanSavePayload payload) {
        return TwOutputUtil.ok(conReceivablePlanService.saveContractRecvPlans(payload));
    }

    @PutMapping("/updateExpectReceDate")
    @ApiOperation("更新预计收款日期")
    public TwOutputUtil updateExpectReceDate(@RequestBody Map<Long, String> updateData) {
        conReceivablePlanService.updateExpectReceDate(updateData);
        return TwOutputUtil.ok();
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConReceivablePlanPayload payload) {
        return TwOutputUtil.ok(conReceivablePlanService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conReceivablePlanService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(conReceivablePlanService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(conReceivablePlanService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conReceivablePlanService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

//    /**
//     * 根据合同ID查询收款计划
//     * @param saleConId 合同ID
//     * @return result
//     */
//    @GetMapping("/plan/{saleConId}")
//    @UdcNameClass
//    @ApiOperation("根据合同ID查询")
//    public TwOutputUtil queryBySaleConId(@PathVariable Long saleConId) {
//        return TwOutputUtil.ok(conReceivablePlanService.queryBySaleConId(saleConId));
//    }

    /**
     * 根据合同ID查询收款计划
     *
     * @param saleConId 合同ID
     * @param query     查询条件
     * @return result
     */
    @GetMapping("/plan/{saleConId}")
    @UdcNameClass
    @ApiOperation("根据合同ID查询")
    public TwOutputUtil queryBySaleConId(@PathVariable Long saleConId, ConReceivablePlanQuery query) {
        return TwOutputUtil.ok(conReceivablePlanService.queryBySaleConId(saleConId, query));
    }

    /**
     * 收款列表批量导出excel
     *
     * @return result
     */
    @ApiOperation("收款列表批量导出excel")
    @GetMapping("/plan/batchReceivablePlanExport")
    public void batchReceivablePlanExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        conReceivablePlanService.batchReceivablePlanExport(response, query);
    }

    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/plan/batchExport")
    public void batchExport(HttpServletResponse response, ConReceivablePlanQuery query) {
        conReceivablePlanService.downloadBatch(response, query);
    }

    @ApiOperation("批量导入excel")
    @PostMapping(value = "/plan/batchImportPro", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImportPro(MultipartFile file, Boolean force, Long saleConId) throws InterruptedException {
        Map<String, Object> resultMap = conReceivablePlanService.importBatchPro(file, force, saleConId);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok();
        } else if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        } else {
            return TwOutputUtil.error("", "", resultMap);
        }
    }

    /* 合同收款作废
     *
     * @param ids 主键
     * @return result
     */
    @PatchMapping("/invalid")
    public TwOutputUtil invalidRecvplan(@RequestParam Long[] ids, @RequestParam String remark) {
        conReceivablePlanService.invalidRecvplan(Arrays.asList(ids), remark);
        return TwOutputUtil.ok();
    }

    /**
     * 变更收款日期
     *
     * @param payload
     * @return
     */
    @PostMapping("/updateRecvOrInvDate")
    public TwOutputUtil updateRecvOrInvDate(@RequestBody ConRecvplanChangeLogPayload payload) {
        Boolean flag = conReceivablePlanService.updateRecvOrInvDate(payload);
        if (flag) {
            return TwOutputUtil.ok();
        } else {
            return TwOutputUtil.error("", "操作失败", null);
        }
    }

    /**
     * 根据合同Id查询约束合同节点
     *
     * @param saleConId 合同Id
     */
    @GetMapping("/findConNodeByConId")
    @UdcNameClass
    public TwOutputUtil<List<ContractNodeVO>> findConNodeByConId(Long saleConId) {
        return TwOutputUtil.ok(conReceivablePlanService.findConNodeByConId(saleConId));
    }

    /**
     * APP查询我的收款和开票数量
     *
     * @param type 类型 （1.我的收款，2.我的开票）
     * @return
     */
    @GetMapping("/queryAppMyHandlNum")
    @ApiOperation("查询我的收款和开票数量")
    public TwOutputUtil queryAppMyHandlNum(String type) {
        return TwOutputUtil.ok(conReceivablePlanService.queryAppMyHandlNum(type));
    }
}
