package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 采购需求处理
 *
 * @author likunpeng
 * @date 2023-03-29
 */
@Entity
@Table(name = "con_purchase_demand", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_purchase_demand", comment = "采购需求处理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConPurchaseDemandDO extends BaseModel implements Serializable  {
    /** 需求编号 */
    @Comment("需求编号")
    @Column()
    private String code;
    /** 需求总金额 */
    @Comment("需求总金额")
    @Column()
    private BigDecimal demandTotalAmt;
    /** 销售合同id */
    @Comment("销售合同id")
    @Column()
    private Long saleConId;

    /** 4.0采购需求id */
    @Comment("4.0采购需求id")
    @Column()
    private Long purDemandIdV4;

    public void copy(ConPurchaseDemandDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
