package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFinPeriodPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFinPeriodQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinPeriodVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFinYearVO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinPeriodDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemFinYearDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemFinPeriodRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 财务期间
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemFinPeriodDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemFinPeriodRepo repo;
    private final QPrdSystemFinPeriodDO qdo = QPrdSystemFinPeriodDO.prdSystemFinPeriodDO;
    //财务年度
    private final QPrdSystemFinYearDO qdoYear = QPrdSystemFinYearDO.prdSystemFinYearDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFinPeriodVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemFinPeriodVO.class,
                qdo.id,
                //备注
                qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 财务年度ID
                qdo.finYearId,
                // 财务期间
                qdo.finPeriod,
                // 期间名称
                qdo.periodName,
                // 期间状态
                qdo.periodStatus,
                // 开始日期
                qdo.beginDate,
                // 结束日期
                qdo.endDate,
                // 财务年度
                qdoYear.finYear
        )).from(qdo)
                .leftJoin(qdoYear).on(qdo.finYearId.longValue().eq(qdoYear.id.longValue()));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemFinPeriodVO> getJpaQueryWhere(PrdSystemFinPeriodQuery query) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            List<OrderItem> orderse = new ArrayList<>();
            orderse.add(OrderItem.desc("beginDate"));
            query.setOrders(orderse);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
            }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PrdSystemFinPeriodQuery query) {
//        long total = jpaQueryFactory
//            .select(qdo.count())
//            .from(qdo)
//            .where(where(query))
//            .fetchOne();
        long total = getJpaQueryWhere(query).fetchCount();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PrdSystemFinPeriodQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 财务年度ID 精确 */
        if (!ObjectUtils.isEmpty(query.getFinYearId())) {
            list.add(qdo.finYearId.eq(query.getFinYearId()));
        }
        /** 财务期间 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriod())) {
            list.add(qdo.finPeriod.eq(query.getFinPeriod()));
        }
        /** 期间名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getPeriodName())) {
             list.add(qdo.periodName.like(SqlUtil.toSqlLikeString(query.getPeriodName())));
        }
        /** 期间状态 精确 */
        if (!ObjectUtils.isEmpty(query.getPeriodStatus())) {
            list.add(qdo.periodStatus.eq(query.getPeriodStatus()));
        }
        /** 开始日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBeginDate())) {
            list.add(qdo.beginDate.eq(query.getBeginDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 财务年度 精确 */
        if (!ObjectUtils.isEmpty(query.getFinYear())) {
            list.add(qdoYear.finYear.eq(query.getFinYear()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemFinPeriodVO queryByKey(Long id) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemFinPeriodVO> queryListDynamic(PrdSystemFinPeriodQuery query) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemFinPeriodVO> queryPaging(PrdSystemFinPeriodQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = getJpaQueryWhere(query);
        List<PrdSystemFinPeriodVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemFinPeriodVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemFinPeriodDO save(PrdSystemFinPeriodDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PrdSystemFinPeriodDO> saveAll(List<PrdSystemFinPeriodDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PrdSystemFinPeriodPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 财务年度ID
        if (payload.getFinYearId() != null) {
            update.set(qdo.finYearId, payload.getFinYearId());
        }
        // 财务期间
        if (payload.getFinPeriod() != null) {
            update.set(qdo.finPeriod, payload.getFinPeriod());
        }
        // 期间名称
        if (payload.getPeriodName() != null) {
            update.set(qdo.periodName, payload.getPeriodName());
        }
        // 期间状态
        if (payload.getPeriodStatus() != null) {
            update.set(qdo.periodStatus, payload.getPeriodStatus());
        }
        // 开始日期
        if (payload.getBeginDate() != null) {
            update.set(qdo.beginDate, payload.getBeginDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 财务年度ID
            if (nullFields.contains("finYearId")) {
                update.setNull(qdo.finYearId);
            }
            // 财务期间
            if (nullFields.contains("finPeriod")) {
                update.setNull(qdo.finPeriod);
            }
            // 期间名称
            if (nullFields.contains("periodName")) {
                update.setNull(qdo.periodName);
            }
            // 期间状态
            if (nullFields.contains("periodStatus")) {
                update.setNull(qdo.periodStatus);
            }
            // 开始日期
            if (nullFields.contains("beginDate")) {
                update.setNull(qdo.beginDate);
            }
            // 结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 查询数据库是否存在该VO
     * @param periodName
     * @return PrdSystemFinYearVO
     */
    public PrdSystemFinPeriodVO selectInspect(String periodName) {
        JPAQuery<PrdSystemFinPeriodVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.periodName.eq(periodName));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }
}

