package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemNewFunctionQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemNewFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgPersonDO;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemNewFunctionRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @Author Bill
 * @Date 2023/9/18 13:13
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemNewFunctionDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final QPrdSystemNewFunctionDO qdo = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final PrdSystemNewFunctionRepo repo;
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgPersonDO qdoPerson = QPrdOrgPersonDO.prdOrgPersonDO;
    // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgEmployeeDO n_qdo = new QPrdOrgEmployeeDO("prdOrgEmployeeDO1");
    private final QPrdSystemUserRoleDO qdoUserRole = QPrdSystemUserRoleDO.prdSystemUserRoleDO;
    private final QPrdSystemRoleFunctionDO qdoRoleFunction = QPrdSystemRoleFunctionDO.prdSystemRoleFunctionDO;
    private final QPrdSystemRoleDO qdoRole = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemPermissionFunctionObjectDO functionObjectDO = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;

    /**
     * 功能列表 模糊查询
     *
     * @param query
     * @return
     */
    public PagingVO<PrdSystemNewFunctionVO> queryByKeyword(PrdSystemNewFunctionQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemNewFunctionVO> jpaQuerySelect = getJpaQueryWhere(query);
        List<PrdSystemNewFunctionVO> result = jpaQuerySelect.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemNewFunctionVO>builder().records(result).total(total).build();
    }

    /**
     * 拼接查询条件
     *
     * @param query
     * @return
     */
    private JPAQuery<PrdSystemNewFunctionVO> getJpaQueryWhere(PrdSystemNewFunctionQuery query) {
        JPAQuery<PrdSystemNewFunctionVO> jpaQuerySelect = getJpaQuerySelect();
        //条件封装
        jpaQuerySelect.where(where(query));
        //常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuerySelect, qdo._super, query);
        //动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect;
    }

    /**
     * 统计
     *
     * @param query
     * @return
     */
    private long count(PrdSystemNewFunctionQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        //常用查询条件拼接
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 拼接查询条件
     *
     * @param query
     * @return
     */
    private Predicate where(PrdSystemNewFunctionQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(query.getObjectId())) {
            list.add(qdo.objectId.eq(query.getObjectId()));
        }
        if (StringUtils.hasText(query.getKeyword())) {
            list.add(qdo.functionCode.like(SqlUtil.toSqlLikeString(query.getKeyword())).or(qdo.functionName.like(SqlUtil.toSqlLikeString(query.getKeyword()))));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemNewFunctionVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemNewFunctionVO.class,
                qdo.id,
                qdo.clientType,
                qdo.createTime,
                qdo.functionCode,
                qdo.functionName,
                qdo.functionStatus,
                qdo.functionType,
                qdo.objectId,
                qdo.remark,
                qdo.parentFunctionCode
        )).from(qdo);
    }

    /**
     * 根据 功能编号查询
     *
     * @param functionCode
     * @return
     */
    public PrdSystemNewFunctionVO queryByFunctionCode(String functionCode) {
        JPAQuery<PrdSystemNewFunctionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.functionCode.eq(functionCode));
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        return jpaQuerySelect.fetchFirst();
    }

    public List<PrdSystemNewFunctionVO> queryByObjectIds(List<Long> objectIds) {
        JPAQuery<PrdSystemNewFunctionVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.objectId.in(objectIds));
        jpaQuerySelect.where(qdo.deleteFlag.eq(0));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询该功能下用户的列表
     *
     * @param query
     * @return
     */
    public PagingVO<PrdOrgEmployeeVO> queryByListUser(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeWhere(query);
        QueryResults<PrdOrgEmployeeVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdOrgEmployeeVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryEmployeeSelect() {
        return jpaQueryFactory.select(Projections.bean(PrdOrgEmployeeVO.class,
                        qdoEmployee.id,
                        qdoEmployee.employeeName,
                        qdoEmployee.userId,
                        qdoPerson.foreignName,
                        qdoPerson.personName,
                        qdoOrg.orgName
                )).from(qdoEmployee).leftJoin(qdoPerson).on(qdoEmployee.personId.longValue().eq(qdoPerson.id.longValue()))
                .leftJoin(qdoEmployeeRef).on(qdoEmployee.userId.longValue().eq(qdoEmployeeRef.userId.longValue()).and(qdoEmployeeRef.isDefault.eq(0)).and(qdoEmployeeRef.isCopy.eq(0)).and(qdoEmployeeRef.deleteFlag.eq(0)))
                .leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoEmployeeRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .leftJoin(n_qdo).on(n_qdo.id.longValue().eq(qdoEmployeeRef.parentId.longValue()).and(n_qdo.deleteFlag.eq(0)))
                .leftJoin(qdoUserRole).on(qdoUserRole.userId.longValue().eq(qdoEmployee.userId.longValue()))
                .leftJoin(qdoRole).on(qdoUserRole.roleId.longValue().eq(qdoRole.id.longValue()).and(qdoRole.deleteFlag.eq(0)))
                .leftJoin(qdoRoleFunction).on(qdoRoleFunction.roleId.longValue().eq(qdoRole.id.longValue()));
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdOrgEmployeeVO> getJpaQueryEmployeeWhere(PrdOrgEmployeeQuery query) {
        JPAQuery<PrdOrgEmployeeVO> jpaQuery = getJpaQueryEmployeeSelect();
        jpaQuery.where(qdoRoleFunction.functionId.longValue().eq(query.getFunctionId()));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdoEmployee._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoEmployee, query.getOrders()));
        jpaQuery.groupBy(qdoEmployee.userId);
        return jpaQuery;
    }

    private JPAQuery<PrdSystemRoleVO> getJpaRoleQuery() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemRoleVO.class,
                        qdoRole.roleName
                )).from(qdoEmployee).leftJoin(qdoUserRole).on(qdoUserRole.userId.longValue().eq(qdoEmployee.userId.longValue()))
                .leftJoin(qdoRole).on(qdoUserRole.roleId.longValue().eq(qdoRole.id.longValue()));
    }

    /**
     * 根据用户主键查询角色
     *
     * @param userId
     * @return
     */
    public List<PrdSystemRoleVO> queryRoleByUserId(Long userId) {
        JPAQuery<PrdSystemRoleVO> jpaRoleQuery = getJpaRoleQuery();
        jpaRoleQuery.where(qdoEmployee.userId.longValue().eq(userId));
        return jpaRoleQuery.fetch();
    }

    public void deleteByIds(List<Long> ids) {
        jpaQueryFactory.delete(qdo)
                .where(qdo.id.in(ids).and(qdo.deleteFlag.eq(0)))
                .execute();
    }

    /**
     * 拼接查询字段
     *
     * @return JPAQuery 对象
     */
    private JPAQuery<PrdSystemNewFunctionVO> getJpaQuerySelectTwo() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemNewFunctionVO.class,
                qdo.id,
                qdo.clientType,
                qdo.createTime,
                qdo.functionCode,
                qdo.functionName,
                qdo.functionStatus,
                qdo.functionType,
                qdo.objectId,
                qdo.remark,
                qdo.parentFunctionCode
        )).from(functionObjectDO).leftJoin(qdo).on(qdo.id.longValue().eq(functionObjectDO.functionId.longValue()));
    }

    public List<PrdSystemNewFunctionVO> queryByObjectId(Long objectId) {
        JPAQuery<PrdSystemNewFunctionVO> jpaQuery = getJpaQuerySelectTwo();
        jpaQuery.where(qdo.objectId.longValue().eq(objectId));
        jpaQuery.groupBy(qdo.id);
        return jpaQuery.fetch();
    }

    /**
     * 通过功能编码查询 业务对象主键
     *
     * @param codeRegx
     * @return
     */
    public Long getObjectIdByFunctionCode(String codeRegx) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.objectId).from(qdo).where(qdo.functionCode.eq(codeRegx));
        return jpaQuery.fetchOne();
    }
}
