package com.elitesland.tw.tw5.server.prd.system.repo;

import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemProblemFeedbackDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Repository
public interface PrdSystemProblemFeedbackRepo extends JpaRepository<PrdSystemProblemFeedbackDO, Long>, QuerydslPredicateExecutor<PrdSystemProblemFeedbackDO> {
    /**
     * 统计时间段内所有问题反馈
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Query(nativeQuery = true,value = "SELECT DATE_FORMAT(pf.create_time, '%Y-%m') as month, count(1) as number FROM prd_system_problem_feedback pf where pf.create_time between :startTime and :endTime group by DATE_FORMAT(pf.create_time, '%Y-%m')")
    List<Map<String, Object>> findNumberStatisticalByAll(@Param("startTime") LocalDateTime startTime, @Param("endTime") LocalDateTime endTime);

    /**
     * 统计时间段内所有已处理的问题反馈
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Query(nativeQuery = true,value = "SELECT DATE_FORMAT(pf.create_time, '%Y-%m') as month, count(1) as number FROM prd_system_problem_feedback pf where pf.create_time between :startTime and :endTime and pf.feedback_status = 'CLOSE' group by DATE_FORMAT(pf.create_time, '%Y-%m')")
    List<Map<String, Object>> findNumberStatisticalByClose(@Param("startTime") LocalDateTime startTime, @Param("endTime")LocalDateTime endTime);

    /**
     * 根据问题类型统计时间段内问题反馈
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Query(nativeQuery = true,value = "SELECT pf.problem_type as problemType, count(1) as number FROM prd_system_problem_feedback pf where pf.create_time between :startTime and :endTime group by pf.problem_type")
    List<Map<String, Object>> findNumberStatisticalGroupByProblemType(@Param("startTime") LocalDateTime startTime, @Param("endTime") LocalDateTime endTime);

    /**
     * 根据所属功能统计时间段内所有问题反馈
     *
     * @param startTime
     * @param endTime
     * @return
     */
    @Query(nativeQuery = true,value = "SELECT pf.function_id as functionId, count(1) as number FROM prd_system_problem_feedback pf where pf.create_time between :startTime and :endTime group by pf.function_id")
    List<Map<String, Object>> findNumberStatisticalGroupByFunctionId(@Param("startTime") LocalDateTime startTime, @Param("endTime") LocalDateTime endTime);

    /**
     * 根据主键id集合查询
     * @param ids
     * @return
     */
    List<PrdSystemProblemFeedbackDO> findByIdIn(Collection<Long> ids);
}
